/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import com.google.common.io.ByteSource;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface BlobStoreDAO {
    public InputStream read(BucketName var1, BlobId var2) throws ObjectStoreIOException, ObjectNotFoundException;

    default public Publisher<ReactiveByteSource> readAsByteSource(BucketName bucketName, BlobId blobId) {
        return Mono.from(this.readBytes(bucketName, blobId)).map(bytes -> new ReactiveByteSource(((byte[])bytes).length, (Publisher<ByteBuffer>)Mono.just((Object)ByteBuffer.wrap(bytes))));
    }

    public Publisher<InputStream> readReactive(BucketName var1, BlobId var2);

    public Publisher<byte[]> readBytes(BucketName var1, BlobId var2);

    public Publisher<Void> save(BucketName var1, BlobId var2, byte[] var3);

    public Publisher<Void> save(BucketName var1, BlobId var2, InputStream var3);

    public Publisher<Void> save(BucketName var1, BlobId var2, ByteSource var3);

    default public Publisher<Void> save(BucketName bucketName, BlobId blobId, String data) {
        return this.save(bucketName, blobId, data.getBytes(StandardCharsets.UTF_8));
    }

    public Publisher<Void> delete(BucketName var1, BlobId var2);

    public Publisher<Void> delete(BucketName var1, Collection<BlobId> var2);

    public Publisher<Void> deleteBucket(BucketName var1);

    public Publisher<BucketName> listBuckets();

    public Publisher<BlobId> listBlobs(BucketName var1);

    public static class ReactiveByteSource {
        private final long size;
        private final Publisher<ByteBuffer> content;

        public ReactiveByteSource(long size, Publisher<ByteBuffer> content) {
            this.size = size;
            this.content = content;
        }

        public long getSize() {
            return this.size;
        }

        public Publisher<ByteBuffer> getContent() {
            return this.content;
        }
    }
}

