/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.james.mailbox.backup.MailboxMessageFixture;
import org.apache.james.mailbox.backup.MailboxWithAnnotations;
import org.apache.james.mailbox.backup.ZipAssert;
import org.apache.james.mailbox.backup.zip.FlagsExtraField;
import org.apache.james.mailbox.backup.zip.InternalDateExtraField;
import org.apache.james.mailbox.backup.zip.MailboxIdExtraField;
import org.apache.james.mailbox.backup.zip.MessageIdExtraField;
import org.apache.james.mailbox.backup.zip.SizeExtraField;
import org.apache.james.mailbox.backup.zip.UidExtraField;
import org.apache.james.mailbox.backup.zip.UidValidityExtraField;
import org.apache.james.mailbox.backup.zip.Zipper;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.store.MessageResultImpl;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ZipperTest {
    private static final List<MailboxWithAnnotations> NO_MAILBOXES = ImmutableList.of();
    private static final MailboxWithAnnotations MAILBOX_1_WITHOUT_ANNOTATION = new MailboxWithAnnotations(MailboxMessageFixture.MAILBOX_1, MailboxMessageFixture.NO_ANNOTATION);
    private static final MailboxWithAnnotations MAILBOX_1_SUB_1_WITHOUT_ANNOTATION = new MailboxWithAnnotations(MailboxMessageFixture.MAILBOX_1_SUB_1, MailboxMessageFixture.NO_ANNOTATION);
    private static final MailboxWithAnnotations MAILBOX_2_WITHOUT_ANNOTATION = new MailboxWithAnnotations(MailboxMessageFixture.MAILBOX_2, MailboxMessageFixture.NO_ANNOTATION);
    private Zipper testee;
    private ByteArrayOutputStream output;
    private static MessageResult MESSAGE_RESULT_1;
    private static MessageResult MESSAGE_RESULT_2;

    ZipperTest() {
    }

    @BeforeAll
    static void beforeAll() throws Exception {
        MESSAGE_RESULT_1 = new MessageResultImpl((MailboxMessage)MailboxMessageFixture.MESSAGE_1);
        MESSAGE_RESULT_2 = new MessageResultImpl((MailboxMessage)MailboxMessageFixture.MESSAGE_2);
    }

    @BeforeEach
    void beforeEach() {
        this.testee = new Zipper();
        this.output = new ByteArrayOutputStream();
    }

    @Test
    void archiveShouldWriteEmptyValidArchiveWhenNoMessage() throws Exception {
        this.testee.archive(NO_MAILBOXES, Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.hasNoEntry();
        }
    }

    @Test
    void archiveShouldWriteOneMessageWhenOne() throws Exception {
        this.testee.archive(NO_MAILBOXES, Stream.of(new MessageResultImpl((MailboxMessage)MailboxMessageFixture.MESSAGE_1)), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MESSAGE_ID_1.serialize()).hasStringContent("Simple message content"));
        }
    }

    @Test
    void archiveShouldWriteTwoMessagesWhenTwo() throws Exception {
        this.testee.archive(NO_MAILBOXES, Stream.of(MESSAGE_RESULT_1, MESSAGE_RESULT_2), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MESSAGE_ID_1.serialize()).hasStringContent("Simple message content"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MESSAGE_ID_2.serialize()).hasStringContent("Other message content"));
        }
    }

    @Test
    void archiveShouldWriteMetadata() throws Exception {
        this.testee.archive(NO_MAILBOXES, Stream.of(MESSAGE_RESULT_1), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MESSAGE_ID_1.serialize()).containsExtraFields(new ZipExtraField[]{new SizeExtraField(MailboxMessageFixture.SIZE_1)}).containsExtraFields(new ZipExtraField[]{new UidExtraField(1111L)}).containsExtraFields(new ZipExtraField[]{new MessageIdExtraField(MailboxMessageFixture.MESSAGE_ID_1.serialize())}).containsExtraFields(new ZipExtraField[]{new MailboxIdExtraField(MailboxMessageFixture.MAILBOX_ID_1)}).containsExtraFields(new ZipExtraField[]{new InternalDateExtraField(MailboxMessageFixture.MESSAGE_1.getInternalDate())}).containsExtraFields(new ZipExtraField[]{new FlagsExtraField(MailboxMessageFixture.MESSAGE_1.createFlags())}));
        }
    }

    @Test
    void archiveShouldWriteOneMailboxWhenPresent() throws Exception {
        this.testee.archive((List)ImmutableList.of((Object)MAILBOX_1_WITHOUT_ANNOTATION), Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/").isDirectory());
        }
    }

    @Test
    void archiveShouldWriteMailboxesWhenPresent() throws Exception {
        this.testee.archive((List)ImmutableList.of((Object)MAILBOX_1_WITHOUT_ANNOTATION, (Object)MAILBOX_2_WITHOUT_ANNOTATION), Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/").isDirectory(), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_2.getName() + "/").isDirectory());
        }
    }

    @Test
    void archiveShouldWriteMailboxHierarchyWhenPresent() throws Exception {
        this.testee.archive((List)ImmutableList.of((Object)MAILBOX_1_WITHOUT_ANNOTATION, (Object)MAILBOX_1_SUB_1_WITHOUT_ANNOTATION, (Object)MAILBOX_2_WITHOUT_ANNOTATION), Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/").isDirectory(), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1_SUB_1.getName() + "/").isDirectory(), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_2.getName() + "/").isDirectory());
        }
    }

    @Test
    void archiveShouldWriteMailboxHierarchyWhenMissingParent() throws Exception {
        this.testee.archive((List)ImmutableList.of((Object)MAILBOX_1_SUB_1_WITHOUT_ANNOTATION, (Object)MAILBOX_2_WITHOUT_ANNOTATION), Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1_SUB_1.getName() + "/").isDirectory(), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_2.getName() + "/").isDirectory());
        }
    }

    @Test
    void archiveShouldWriteMailboxMetadataWhenPresent() throws Exception {
        this.testee.archive((List)ImmutableList.of((Object)MAILBOX_1_WITHOUT_ANNOTATION), Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/").containsExtraFields(new ZipExtraField[]{new MailboxIdExtraField(MailboxMessageFixture.MAILBOX_1.getMailboxId()), new UidValidityExtraField(MailboxMessageFixture.MAILBOX_1.getUidValidity().asLong())}));
        }
    }

    @Test
    void archiveShouldWriteMailBoxWithoutAnAnnotationSubDirWhenEmpty() throws Exception {
        this.testee.archive((List)ImmutableList.of((Object)MAILBOX_1_WITHOUT_ANNOTATION), Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/"));
        }
    }

    @Test
    void archiveShouldWriteMailboxAnnotationsInASubDirWhenPresent() throws Exception {
        this.testee.archive((List)ImmutableList.of((Object)new MailboxWithAnnotations(MailboxMessageFixture.MAILBOX_1, MailboxMessageFixture.WITH_ANNOTATION_1)), Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/").isDirectory(), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/" + MailboxMessageFixture.ANNOTATION_1.getKey().asString()));
        }
    }

    @Test
    void archiveShouldWriteMailboxAnnotationsInASubDirWhenTwoPresent() throws Exception {
        this.testee.archive((List)ImmutableList.of((Object)new MailboxWithAnnotations(MailboxMessageFixture.MAILBOX_1, MailboxMessageFixture.WITH_ANNOTATION_1_AND_2)), Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/").isDirectory(), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/" + MailboxMessageFixture.ANNOTATION_1.getKey().asString()).hasStringContent("annotation1 content"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/" + MailboxMessageFixture.ANNOTATION_2.getKey().asString()).hasStringContent("annotation2 content"));
        }
    }

    @Test
    void archiveShouldWriteMailboxAnnotationsInASubDirWhenTwoPresentWithTheSameName() throws Exception {
        this.testee.archive((List)ImmutableList.of((Object)new MailboxWithAnnotations(MailboxMessageFixture.MAILBOX_1, (List)ImmutableList.of((Object)MailboxMessageFixture.ANNOTATION_1, (Object)MailboxMessageFixture.ANNOTATION_1_BIS))), Stream.of(new MessageResult[0]), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/").isDirectory(), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/" + MailboxMessageFixture.ANNOTATION_1.getKey().asString()).hasStringContent("annotation1 content"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/" + MailboxMessageFixture.ANNOTATION_1.getKey().asString()).hasStringContent("annotation1 bis content"));
        }
    }

    @Test
    void entriesInArchiveShouldBeOrderedLikeMailboxWithItsAnnotationsThenMessages() throws Exception {
        MailboxWithAnnotations mailbox1 = new MailboxWithAnnotations(MailboxMessageFixture.MAILBOX_1, (List)ImmutableList.of((Object)MailboxMessageFixture.ANNOTATION_1));
        MailboxWithAnnotations mailbox2 = new MailboxWithAnnotations(MailboxMessageFixture.MAILBOX_2, (List)ImmutableList.of((Object)MailboxMessageFixture.ANNOTATION_2));
        this.testee.archive((List)ImmutableList.of((Object)mailbox1, (Object)mailbox2), Stream.of(MESSAGE_RESULT_1, MESSAGE_RESULT_2), (OutputStream)this.output);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(this.output);){
            zipAssert.containsExactlyEntriesMatching(ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/").isDirectory(), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_1.getName() + "/annotations/" + MailboxMessageFixture.ANNOTATION_1.getKey().asString()).hasStringContent("annotation1 content"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_2.getName() + "/"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_2.getName() + "/annotations/").isDirectory(), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MAILBOX_2.getName() + "/annotations/" + MailboxMessageFixture.ANNOTATION_2.getKey().asString()).hasStringContent("annotation2 content"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MESSAGE_ID_1.serialize()).hasStringContent("Simple message content"), ZipAssert.EntryChecks.hasName(MailboxMessageFixture.MESSAGE_ID_2.serialize()).hasStringContent("Other message content"));
        }
    }
}

