/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import java.util.zip.ZipException;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.james.mailbox.backup.zip.EntryTypeExtraField;
import org.apache.james.mailbox.backup.zip.ZipEntryType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ZipEntryTypeExtraFieldTest {
    private static final byte[] ZERO_AS_BYTE_ARRAY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] ONE_AS_BYTE_ARRAY = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] TWO_AS_BYTE_ARRAY = new byte[]{2, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] THREE_AS_BYTE_ARRAY = new byte[]{3, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] FOUR_AS_BYTE_ARRAY = new byte[]{4, 0, 0, 0, 0, 0, 0, 0};
    private EntryTypeExtraField testee;

    ZipEntryTypeExtraFieldTest() {
    }

    @BeforeEach
    void setUp() {
        this.testee = new EntryTypeExtraField();
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(EntryTypeExtraField.class).suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }

    @Test
    void getLocalFileDataLengthShouldReturnIntegerSize() {
        Assertions.assertThat((int)this.testee.getLocalFileDataLength().getValue()).isEqualTo(8);
    }

    @Test
    void getCentralDirectoryLengthShouldReturnIntegerSize() {
        Assertions.assertThat((int)this.testee.getCentralDirectoryLength().getValue()).isEqualTo(8);
    }

    @Test
    void getHeaderIdShouldReturnSpecificStringInLittleEndian() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.testee.getHeaderId().getBytes()).order(ByteOrder.LITTLE_ENDIAN);
        Assertions.assertThat((String)Charsets.US_ASCII.decode(byteBuffer).toString()).isEqualTo("aq");
    }

    @Test
    void getLocalFileDataDataShouldThrowWhenNoValue() {
        Assertions.assertThatThrownBy(() -> this.testee.getLocalFileDataData()).isInstanceOf(RuntimeException.class);
    }

    @Test
    void getLocalFileDataShouldReturnValueInLittleIndianWhenMailbox() {
        byte[] actual = new EntryTypeExtraField(ZipEntryType.MAILBOX).getLocalFileDataData();
        Assertions.assertThat((byte[])actual).isEqualTo((Object)ZERO_AS_BYTE_ARRAY);
    }

    @Test
    void getLocalFileDataShouldReturnValueInLittleIndianWhenMailboxAnnotationDir() {
        byte[] actual = new EntryTypeExtraField(ZipEntryType.MAILBOX_ANNOTATION_DIR).getLocalFileDataData();
        Assertions.assertThat((byte[])actual).isEqualTo((Object)ONE_AS_BYTE_ARRAY);
    }

    @Test
    void getLocalFileDataShouldReturnValueInLittleIndianWhenMailboxAnnotation() {
        byte[] actual = new EntryTypeExtraField(ZipEntryType.MAILBOX_ANNOTATION).getLocalFileDataData();
        Assertions.assertThat((byte[])actual).isEqualTo((Object)TWO_AS_BYTE_ARRAY);
    }

    @Test
    void getLocalFileDataShouldReturnValueInLittleIndianWhenMessage() {
        byte[] actual = new EntryTypeExtraField(ZipEntryType.MESSAGE).getLocalFileDataData();
        Assertions.assertThat((byte[])actual).isEqualTo((Object)THREE_AS_BYTE_ARRAY);
    }

    @Test
    void getCentralDirectoryDataShouldThrowWhenNoValue() {
        Assertions.assertThatThrownBy(() -> this.testee.getCentralDirectoryData()).isInstanceOf(RuntimeException.class);
    }

    @Test
    void getCentralDirectoryDataShouldReturnValueInLittleIndianWhenMailbox() {
        byte[] actual = new EntryTypeExtraField(ZipEntryType.MAILBOX).getCentralDirectoryData();
        Assertions.assertThat((byte[])actual).isEqualTo((Object)ZERO_AS_BYTE_ARRAY);
    }

    @Test
    void getCentralDirectoryDataShouldReturnValueInLittleIndianWhenMailboxAnnotationDir() {
        byte[] actual = new EntryTypeExtraField(ZipEntryType.MAILBOX_ANNOTATION_DIR).getCentralDirectoryData();
        Assertions.assertThat((byte[])actual).isEqualTo((Object)ONE_AS_BYTE_ARRAY);
    }

    @Test
    void getCentralDirectoryDataShouldReturnValueInLittleIndianWhenMailboxAnnotation() {
        byte[] actual = new EntryTypeExtraField(ZipEntryType.MAILBOX_ANNOTATION).getCentralDirectoryData();
        Assertions.assertThat((byte[])actual).isEqualTo((Object)TWO_AS_BYTE_ARRAY);
    }

    @Test
    void getCentralDirectoryDataShouldReturnValueInLittleIndianWhenMessage() {
        byte[] actual = new EntryTypeExtraField(ZipEntryType.MESSAGE).getCentralDirectoryData();
        Assertions.assertThat((byte[])actual).isEqualTo((Object)THREE_AS_BYTE_ARRAY);
    }

    @Test
    void parseFromLocalFileDataShouldThrownWhenLengthIsSmallerThan8() {
        byte[] input = new byte[7];
        Assertions.assertThatThrownBy(() -> this.testee.parseFromLocalFileData(input, 0, 7)).isInstanceOf(ZipException.class);
    }

    @Test
    void parseFromLocalFileDataShouldThrownWhenLengthIsBiggerThan8() {
        byte[] input = new byte[8];
        Assertions.assertThatThrownBy(() -> this.testee.parseFromLocalFileData(input, 0, 9)).isInstanceOf(ZipException.class);
    }

    @Test
    void parseFromCentralDirectoryDataShouldThrownWhenLengthIsSmallerThan8() {
        byte[] input = new byte[7];
        Assertions.assertThatThrownBy(() -> this.testee.parseFromCentralDirectoryData(input, 0, 7)).isInstanceOf(ZipException.class);
    }

    @Test
    void parseFromCentralDirectoryDataShouldThrownWhenLengthIsBiggerThan8() {
        byte[] input = new byte[9];
        Assertions.assertThatThrownBy(() -> this.testee.parseFromCentralDirectoryData(input, 0, 9)).isInstanceOf(ZipException.class);
    }

    @Test
    void parseFromCentralDirectoryDataShouldParseWhenNotAnEnumValue() throws Exception {
        this.testee.parseFromCentralDirectoryData(FOUR_AS_BYTE_ARRAY, 0, 8);
        Assertions.assertThat((Optional)this.testee.getValue()).contains((Object)4L);
        Assertions.assertThat((Optional)this.testee.getEnumValue()).isEqualTo(Optional.empty());
    }
}

