/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import java.util.Optional;
import org.apache.james.mailbox.backup.zip.ZipEntryType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ZipEntryTypeContract {
    ZipEntryTypeContract() {
    }

    private void assertZipEntryTypeDeserializedFromValue(int value, ZipEntryType expectedType) {
        Assertions.assertThat((Optional)ZipEntryType.zipEntryType((int)value)).contains((Object)expectedType);
    }

    @Test
    void mailboxShouldBeDeserializedFromOne() {
        this.assertZipEntryTypeDeserializedFromValue(0, ZipEntryType.MAILBOX);
    }

    @Test
    void mailboxAnnotationDirShouldBeDeserializedFromTwo() {
        this.assertZipEntryTypeDeserializedFromValue(1, ZipEntryType.MAILBOX_ANNOTATION_DIR);
    }

    @Test
    void mailboxAnnotationShouldBeDeserializedFromThree() {
        this.assertZipEntryTypeDeserializedFromValue(2, ZipEntryType.MAILBOX_ANNOTATION);
    }

    @Test
    void messageShouldBeDeserializedFromFour() {
        this.assertZipEntryTypeDeserializedFromValue(3, ZipEntryType.MESSAGE);
    }
}

