/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.backup.ZipArchiveEntryAssert;
import org.apache.james.mailbox.backup.zip.WithZipHeader;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ZipAssert
extends AbstractAssert<ZipAssert, ZipFile>
implements AutoCloseable {
    private final ZipFile zipFile;

    public static ZipAssert assertThatZip(ZipFile zipFile) {
        return new ZipAssert(zipFile);
    }

    public static ZipAssert assertThatZip(ByteArrayOutputStream outputStream) throws IOException {
        return ZipAssert.assertThatZip(new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(outputStream.toByteArray())));
    }

    public static ZipAssert assertThatZip(InputStream inputStream) throws IOException {
        return ZipAssert.assertThatZip(ZipAssert.zipFileFromInputStream(inputStream));
    }

    private static ZipFile zipFileFromInputStream(InputStream inputStream) throws IOException {
        return new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(IOUtils.toByteArray((InputStream)inputStream)));
    }

    private static BasicErrorMessageFactory shouldHaveSize(ZipFile zipFile, int expected, int actual) {
        return new BasicErrorMessageFactory("%nExpecting %s to have size %s but was %s", new Object[]{zipFile, expected, actual});
    }

    private static BasicErrorMessageFactory shouldBeEmpty(ZipFile zipFile) {
        return new BasicErrorMessageFactory("%nExpecting %s to be empty", new Object[]{zipFile});
    }

    private static BasicErrorMessageFactory shouldBeNonNull() {
        return new BasicErrorMessageFactory("%nExpecting zipFile to be non-null", new Object[0]);
    }

    private static BasicErrorMessageFactory shouldHaveSameEntriesSize(List<ZipArchiveEntry> entries, List<ZipArchiveEntry> expectedEntries) {
        return new BasicErrorMessageFactory("%nExpecting zipFile to contains %s entries (%s) but actually contains (%s)", new Object[]{expectedEntries.size(), expectedEntries, entries});
    }

    private static BasicErrorMessageFactory shouldHaveEntriesSize(int entriesSize, int expectedEntriesSize) {
        return new BasicErrorMessageFactory("%nExpecting zipFile to contains %s entries but actually contains (%s) entries", new Object[]{expectedEntriesSize, entriesSize});
    }

    private static ErrorMessageFactory entriesShouldHaveSameContentAt(int entryIndex) {
        return new BasicErrorMessageFactory("%nExpecting zipFile entry at index %s has same content", new Object[]{entryIndex});
    }

    private static ErrorMessageFactory entriesShouldHaveSameName(ZipArchiveEntry entry, ZipArchiveEntry expectedEntry, int entryIndex) {
        return new BasicErrorMessageFactory("%nExpecting zipFile entry name (%s) at index %s but actually (%s)", new Object[]{expectedEntry.getName(), entryIndex, entry.getName()});
    }

    private static ErrorMessageFactory entriesShouldHaveSameExtraFields(ZipArchiveEntry entry, ZipArchiveEntry expectedEntry, int entryIndex) {
        return new BasicErrorMessageFactory("%nExpecting zipFile entry at index %s has extra fields (%s) but actually (%s)", new Object[]{entryIndex, expectedEntry.getExtraFields(), entry.getExtraFields()});
    }

    private ZipAssert(ZipFile zipFile) {
        super((Object)zipFile, ZipAssert.class);
        this.zipFile = zipFile;
    }

    private ZipAssert containsEntriesMatchingWithComparator(Optional<Comparator<ZipArchiveEntry>> sortEntriesBy, Optional<Comparator<EntryChecks>> sortEntryChecksBy, EntryChecks ... entryChecks) throws Exception {
        this.isNotNull();
        Stream<EntryChecks> entryChecksStream = Arrays.stream(entryChecks);
        List<EntryChecks> sortedEntryChecks = this.sortAndCollect(sortEntryChecksBy, entryChecksStream);
        Stream entryStream = Collections.list(this.zipFile.getEntries()).stream();
        List entries = this.sortAndCollect(sortEntriesBy, entryStream);
        if (entries.size() != entryChecks.length) {
            this.throwAssertionError((ErrorMessageFactory)ZipAssert.shouldHaveSize(this.zipFile, entryChecks.length, entries.size()));
        }
        for (int i = 0; i < entries.size(); ++i) {
            sortedEntryChecks.get((int)i).check.test(ZipArchiveEntryAssert.assertThatZipEntry(this.zipFile, (ZipArchiveEntry)entries.get(i)));
        }
        return (ZipAssert)this.myself;
    }

    private <T> List<T> sortAndCollect(Optional<Comparator<T>> sortBy, Stream<T> stream) {
        Stream<T> sortedStream = sortBy.map(comparator -> stream.sorted((Comparator)comparator)).orElse(stream);
        return (List)sortedStream.collect(ImmutableList.toImmutableList());
    }

    public ZipAssert containsOnlyEntriesMatching(EntryChecks ... entryChecks) throws Exception {
        Comparator<ZipArchiveEntry> entryComparator = Comparator.comparing(ZipArchiveEntry::getName);
        Comparator<EntryChecks> entryCheckComparator = Comparator.comparing(check -> check.name);
        return this.containsEntriesMatchingWithComparator(Optional.of(entryComparator), Optional.of(entryCheckComparator), entryChecks);
    }

    public ZipAssert containsExactlyEntriesMatching(EntryChecks ... entryChecks) throws Exception {
        return this.containsEntriesMatchingWithComparator(Optional.empty(), Optional.empty(), entryChecks);
    }

    public ZipAssert hasNoEntry() {
        this.isNotNull();
        if (this.zipFile.getEntries().hasMoreElements()) {
            this.throwAssertionError((ErrorMessageFactory)ZipAssert.shouldBeEmpty(this.zipFile));
        }
        return (ZipAssert)this.myself;
    }

    public ZipAssert hasEntriesSize(int expectedSize) {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)expectedSize).describedAs("expectedSize cannot be a negative number", new Object[0])).isGreaterThanOrEqualTo(0);
        ArrayList zipEntries = Collections.list(this.zipFile.getEntries());
        if (zipEntries.size() != expectedSize) {
            this.throwAssertionError((ErrorMessageFactory)ZipAssert.shouldHaveEntriesSize(zipEntries.size(), expectedSize));
        }
        return (ZipAssert)this.myself;
    }

    public ZipAssert allSatisfies(UnaryOperator<EntryChecks> entryChecksOperator) throws Exception {
        this.isNotNull();
        ArrayList<ZipArchiveEntry> entries = Collections.list(this.zipFile.getEntries());
        for (ZipArchiveEntry entry : entries) {
            EntryChecks composedEntryChecks = (EntryChecks)entryChecksOperator.apply(new EntryChecks(entry.getName(), EntryCheck.defaultNoCheck()));
            ZipArchiveEntryAssert zipAssertionOfEntry = ZipArchiveEntryAssert.assertThatZipEntry(this.zipFile, entry);
            composedEntryChecks.check.test(zipAssertionOfEntry);
        }
        return (ZipAssert)this.myself;
    }

    @Override
    public void close() throws Exception {
        this.zipFile.close();
    }

    public ZipAssert hasSameContentWith(InputStream inputStream) throws IOException {
        return this.hasSameContentWith(ZipAssert.zipFileFromInputStream(inputStream));
    }

    public ZipAssert hasSameContentWith(ZipFile anotherZipFile) throws IOException {
        this.validateNonNull(this.zipFile);
        this.validateNonNull(anotherZipFile);
        ArrayList<ZipArchiveEntry> entries = Collections.list(this.zipFile.getEntries());
        ArrayList<ZipArchiveEntry> entriesOfAnother = Collections.list(anotherZipFile.getEntries());
        if (entries.size() != entriesOfAnother.size()) {
            this.throwAssertionError((ErrorMessageFactory)ZipAssert.shouldHaveSameEntriesSize(entries, entriesOfAnother));
        }
        for (int entryIndex = 0; entryIndex < entries.size(); ++entryIndex) {
            ZipArchiveEntry entry = entries.get(entryIndex);
            ZipArchiveEntry entryOfAnother = entriesOfAnother.get(entryIndex);
            this.haveSameName(entry, entryOfAnother, entryIndex);
            this.haveSameExtraFields(entry, entryOfAnother, entryIndex);
            this.haveSameContentAt(this.zipFile.getInputStream(entry), anotherZipFile.getInputStream(entryOfAnother), entryIndex);
        }
        return (ZipAssert)this.myself;
    }

    private void haveSameName(ZipArchiveEntry entry, ZipArchiveEntry expectedEntry, int entryIndex) {
        try {
            Assertions.assertThat((String)entry.getName()).isEqualTo(expectedEntry.getName());
        }
        catch (AssertionError assertionError) {
            this.throwAssertionError(ZipAssert.entriesShouldHaveSameName(entry, expectedEntry, entryIndex));
        }
    }

    private void haveSameExtraFields(ZipArchiveEntry entry, ZipArchiveEntry expectedEntry, int entryIndex) {
        try {
            Assertions.assertThat(this.extractJamesExtraFields(entry)).containsExactlyElementsOf(this.extractJamesExtraFields(expectedEntry));
        }
        catch (AssertionError assertionError) {
            this.throwAssertionError(ZipAssert.entriesShouldHaveSameExtraFields(entry, expectedEntry, entryIndex));
        }
    }

    private void haveSameContentAt(InputStream entryContent, InputStream expectingEntryContent, int entryIndex) {
        try {
            Assertions.assertThat((InputStream)entryContent).hasSameContentAs(expectingEntryContent);
        }
        catch (AssertionError assertionError) {
            this.throwAssertionError(ZipAssert.entriesShouldHaveSameContentAt(entryIndex));
        }
    }

    private void validateNonNull(ZipFile zipFile) {
        if (zipFile == null) {
            this.throwAssertionError((ErrorMessageFactory)ZipAssert.shouldBeNonNull());
        }
    }

    private ImmutableList<ZipExtraField> extractJamesExtraFields(ZipArchiveEntry entry) {
        return (ImmutableList)Stream.of(entry.getExtraFields()).filter(field -> field instanceof WithZipHeader).collect(ImmutableList.toImmutableList());
    }

    public static class EntryChecks {
        private final String name;
        private final EntryCheck check;

        public static EntryChecks hasName(String name) {
            return new EntryChecks(name, assertion -> assertion.hasName(name));
        }

        private EntryChecks(String name, EntryCheck check) {
            this.name = name;
            this.check = check;
        }

        public EntryChecks check(EntryCheck additionalCheck) {
            return new EntryChecks(this.name, this.check.compose(additionalCheck));
        }

        public EntryChecks hasStringContent(String stringContent) {
            return this.check(this.check.compose(assertion -> assertion.hasStringContent(stringContent)));
        }

        public EntryChecks isDirectory() {
            return this.check(this.check.compose(assertion -> assertion.isDirectory()));
        }

        public EntryChecks containsExtraFields(ZipExtraField ... expectedExtraFields) {
            return this.check(this.check.compose(assertion -> assertion.containsExtraFields(expectedExtraFields)));
        }
    }

    static interface EntryCheck {
        public static EntryCheck defaultNoCheck() {
            return assertion -> assertion;
        }

        default public EntryCheck compose(EntryCheck other) {
            return assertion -> other.test(this.test(assertion));
        }

        public ZipArchiveEntryAssert test(ZipArchiveEntryAssert var1) throws Exception;
    }
}

