/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.github.fge.lambdas.Throwing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.backup.ArchiveService;
import org.apache.james.mailbox.backup.DefaultMailboxBackup;
import org.apache.james.mailbox.backup.MailArchiveIterator;
import org.apache.james.mailbox.backup.MailArchiveRestorer;
import org.apache.james.mailbox.backup.MailArchivesLoader;
import org.apache.james.mailbox.backup.MailboxMessageFixture;
import org.apache.james.mailbox.backup.MailboxWithAnnotationsArchiveEntry;
import org.apache.james.mailbox.backup.ZipMailArchiveRestorer;
import org.apache.james.mailbox.backup.zip.ZipArchivesLoader;
import org.apache.james.mailbox.backup.zip.Zipper;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.model.ByteSourceContent;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ZipArchivesLoaderTest
implements MailboxMessageFixture {
    private static final int BUFFER_SIZE = 4096;
    private final ArchiveService archiveService = new Zipper();
    private final MailArchivesLoader archiveLoader = new ZipArchivesLoader();
    private MailArchiveRestorer archiveRestorer;
    private MailboxManager mailboxManager;
    private DefaultMailboxBackup backup;

    ZipArchivesLoaderTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.mailboxManager = InMemoryIntegrationResources.defaultResources().getMailboxManager();
        this.archiveRestorer = new ZipMailArchiveRestorer(this.mailboxManager, this.archiveLoader);
        this.backup = new DefaultMailboxBackup(this.mailboxManager, this.archiveService, this.archiveRestorer);
    }

    private void createMailBoxWithMessage(MailboxPath mailboxPath, MailboxMessage ... messages) throws Exception {
        MailboxSession session = this.mailboxManager.createSystemSession(mailboxPath.getUser());
        MailboxId mailboxId = (MailboxId)this.mailboxManager.createMailbox(mailboxPath, session).get();
        Arrays.stream(messages).forEach((Consumer<MailboxMessage>)Throwing.consumer(message -> {
            MessageManager.AppendCommand appendCommand = MessageManager.AppendCommand.builder().withFlags(message.createFlags()).build((Content)ByteSourceContent.of((InputStream)message.getFullContent()));
            this.mailboxManager.getMailbox(mailboxId, session).appendMessage(appendCommand, session);
        }));
    }

    @Test
    void mailAccountIteratorFromEmptyArchiveShouldThrowNoSuchElementException() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        ByteArrayInputStream source = new ByteArrayInputStream(destination.toByteArray());
        MailArchiveIterator mailArchiveIterator = this.archiveLoader.load((InputStream)source);
        Assertions.assertThat((boolean)mailArchiveIterator.hasNext()).isEqualTo(false);
        Assertions.assertThatThrownBy(() -> mailArchiveIterator.next()).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void callingNextSeveralTimeOnAnEmptyIteratorShouldThrowNoSuchElementException() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        ByteArrayInputStream source = new ByteArrayInputStream(destination.toByteArray());
        MailArchiveIterator mailArchiveIterator = this.archiveLoader.load((InputStream)source);
        Assertions.assertThat((boolean)mailArchiveIterator.hasNext()).isEqualTo(false);
        Assertions.assertThatThrownBy(() -> mailArchiveIterator.next()).isInstanceOf(NoSuchElementException.class);
        Assertions.assertThatThrownBy(() -> mailArchiveIterator.next()).isInstanceOf(NoSuchElementException.class);
        Assertions.assertThatThrownBy(() -> mailArchiveIterator.next()).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void mailAccountIteratorFromArchiveWithOneMailboxShouldContainOneMailbox() throws Exception {
        this.createMailBoxWithMessage(MAILBOX_PATH_USER1_MAILBOX1, new MailboxMessage[0]);
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        ByteArrayInputStream source = new ByteArrayInputStream(destination.toByteArray());
        MailArchiveIterator mailArchiveIterator = this.archiveLoader.load((InputStream)source);
        Assertions.assertThat((boolean)mailArchiveIterator.hasNext()).isEqualTo(true);
        MailboxWithAnnotationsArchiveEntry expectedMailbox = new MailboxWithAnnotationsArchiveEntry("mailbox1", SERIALIZED_MAILBOX_ID_1, NO_ANNOTATION);
        MailboxWithAnnotationsArchiveEntry resultMailbox = (MailboxWithAnnotationsArchiveEntry)mailArchiveIterator.next();
        this.verifyMailboxArchiveEntry(mailArchiveIterator, expectedMailbox, resultMailbox, false);
    }

    @Test
    void mailAccountIteratorFromArchiveWithTwoMailboxesShouldContainTwoMailboxes() throws Exception {
        this.createMailBoxWithMessage(MAILBOX_PATH_USER1_MAILBOX1, new MailboxMessage[0]);
        this.createMailBoxWithMessage(MAILBOX_PATH_USER1_MAILBOX2, new MailboxMessage[0]);
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        ByteArrayInputStream source = new ByteArrayInputStream(destination.toByteArray());
        MailArchiveIterator mailArchiveIterator = this.archiveLoader.load((InputStream)source);
        Assertions.assertThat((boolean)mailArchiveIterator.hasNext()).isEqualTo(true);
        MailboxWithAnnotationsArchiveEntry expectedMailbox = new MailboxWithAnnotationsArchiveEntry("mailbox1", SERIALIZED_MAILBOX_ID_1, NO_ANNOTATION);
        MailboxWithAnnotationsArchiveEntry resultMailbox = (MailboxWithAnnotationsArchiveEntry)mailArchiveIterator.next();
        this.verifyMailboxArchiveEntry(mailArchiveIterator, expectedMailbox, resultMailbox, true);
        MailboxWithAnnotationsArchiveEntry expectedSecondMailbox = new MailboxWithAnnotationsArchiveEntry("mailbox2", SERIALIZED_MAILBOX_ID_2, NO_ANNOTATION);
        MailboxWithAnnotationsArchiveEntry resultSecondMailbox = (MailboxWithAnnotationsArchiveEntry)mailArchiveIterator.next();
        this.verifyMailboxArchiveEntry(mailArchiveIterator, expectedSecondMailbox, resultSecondMailbox, false);
    }

    private void verifyMailboxArchiveEntry(MailArchiveIterator mailArchiveIterator, MailboxWithAnnotationsArchiveEntry expectedMailbox, MailboxWithAnnotationsArchiveEntry resultMailbox, boolean iteratorHasNextElement) {
        Assertions.assertThat((Object)resultMailbox.getMailboxId()).isEqualTo((Object)expectedMailbox.getMailboxId());
        Assertions.assertThat((String)resultMailbox.getMailboxName()).isEqualTo(expectedMailbox.getMailboxName());
        Assertions.assertThat((List)resultMailbox.getAnnotations()).isEqualTo((Object)expectedMailbox.getAnnotations());
        Assertions.assertThat((Object)resultMailbox).isEqualTo((Object)expectedMailbox);
        Assertions.assertThat((boolean)mailArchiveIterator.hasNext()).isEqualTo(iteratorHasNextElement);
    }
}

