/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ZipArchiveEntryAssert
extends AbstractAssert<ZipArchiveEntryAssert, ZipArchiveEntry> {
    private final ZipFile zipFile;
    private final ZipArchiveEntry actual;

    public static ZipArchiveEntryAssert assertThatZipEntry(ZipFile zipFile, ZipArchiveEntry zipArchiveEntry) {
        return new ZipArchiveEntryAssert(zipFile, zipArchiveEntry);
    }

    private static BasicErrorMessageFactory shouldBeADirectory(ZipArchiveEntry zipArchiveEntry) {
        return new BasicErrorMessageFactory("%nExpecting %s to be a directory but was not", new Object[]{zipArchiveEntry});
    }

    private static BasicErrorMessageFactory shouldHaveName(ZipArchiveEntry zipArchiveEntry, String expected) {
        return new BasicErrorMessageFactory("%nExpecting %s to have name %s but was %s", new Object[]{zipArchiveEntry, expected, zipArchiveEntry.getName()});
    }

    private static BasicErrorMessageFactory contentShouldBePresent(ZipArchiveEntry zipArchiveEntry) {
        return new BasicErrorMessageFactory("%nCould not retrieve %s content", new Object[]{zipArchiveEntry});
    }

    private static BasicErrorMessageFactory shouldHaveContent(ZipArchiveEntry zipArchiveEntry, String expectedContent, String actualContent) {
        return new BasicErrorMessageFactory("%nExpecting %s to have content %s but was %s", new Object[]{zipArchiveEntry, expectedContent, actualContent});
    }

    private ZipArchiveEntryAssert(ZipFile zipFile, ZipArchiveEntry zipArchiveEntry) {
        super((Object)zipArchiveEntry, ZipArchiveEntryAssert.class);
        this.zipFile = zipFile;
        this.actual = zipArchiveEntry;
    }

    public ZipArchiveEntryAssert isDirectory() {
        this.isNotNull();
        if (!this.actual.isDirectory()) {
            this.throwAssertionError((ErrorMessageFactory)ZipArchiveEntryAssert.shouldBeADirectory(this.actual));
        }
        return (ZipArchiveEntryAssert)this.myself;
    }

    public ZipArchiveEntryAssert hasName(String name) {
        this.isNotNull();
        if (!this.actual.getName().equals(name)) {
            this.throwAssertionError((ErrorMessageFactory)ZipArchiveEntryAssert.shouldHaveName(this.actual, name));
        }
        return (ZipArchiveEntryAssert)this.myself;
    }

    public ZipArchiveEntryAssert hasStringContent(String content) throws IOException {
        String actualContentAsString;
        this.isNotNull();
        InputStream inputStream = this.zipFile.getInputStream(this.actual);
        if (inputStream == null) {
            this.throwAssertionError((ErrorMessageFactory)ZipArchiveEntryAssert.contentShouldBePresent(this.actual));
        }
        if (!(actualContentAsString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8)).equals(content)) {
            this.throwAssertionError((ErrorMessageFactory)ZipArchiveEntryAssert.shouldHaveContent(this.actual, content, actualContentAsString));
        }
        return (ZipArchiveEntryAssert)this.myself;
    }

    public ZipArchiveEntryAssert containsExtraFields(ZipExtraField ... expectedExtraFields) {
        this.isNotNull();
        Object[] actualExtraFields = this.actual.getExtraFields();
        if (expectedExtraFields.length == 0) {
            return (ZipArchiveEntryAssert)this.myself;
        }
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actualExtraFields).as(String.format("Asserting Zip entry %s extra fields.", this.actual), new Object[0])).contains((Object[])expectedExtraFields);
        return (ZipArchiveEntryAssert)this.myself;
    }
}

