/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.base.Charsets;
import com.google.common.primitives.Bytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import java.util.zip.ZipException;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.james.mailbox.backup.zip.UidExtraField;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class UidExtraFieldTest {
    private static final byte[] ZERO_AS_BYTE_ARRAY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] _123456789ABCDEF0_AS_LE_BYTE_ARRAY = new byte[]{-16, -34, -68, -102, 120, 86, 52, 18};
    private static final byte[] FEDCBA9876543210_AS_LE_BYTE_ARRAY = new byte[]{16, 50, 84, 118, -104, -70, -36, -2};
    private static final byte[] UNUSED = new byte[]{-34, -83};

    UidExtraFieldTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(UidExtraField.class).suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }

    @Nested
    class ParseFromCentralDirectoryData {
        ParseFromCentralDirectoryData() {
        }

        @Test
        void parseFromCentralDirectoryDataShouldThrownWhenLengthIsSmallerThan8() {
            UidExtraField testee = new UidExtraField();
            byte[] input = new byte[7];
            Assertions.assertThatThrownBy(() -> testee.parseFromCentralDirectoryData(input, 0, 7)).isInstanceOf(ZipException.class);
        }

        @Test
        void parseFromCentralDirectoryDataShouldThrownWhenLengthIsBiggerThan8() {
            UidExtraField testee = new UidExtraField();
            byte[] input = new byte[9];
            Assertions.assertThatThrownBy(() -> testee.parseFromCentralDirectoryData(input, 0, 9)).isInstanceOf(ZipException.class);
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseWhenZero() throws Exception {
            UidExtraField testee = new UidExtraField();
            testee.parseFromCentralDirectoryData(ZERO_AS_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)0L);
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseWhen123456789ABCDEF0InLittleEndian() throws Exception {
            UidExtraField testee = new UidExtraField();
            testee.parseFromCentralDirectoryData(_123456789ABCDEF0_AS_LE_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)1311768467463790320L);
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseWhenFEDCBA9876543210InLittleEndian() throws Exception {
            UidExtraField testee = new UidExtraField();
            byte[] input = FEDCBA9876543210_AS_LE_BYTE_ARRAY;
            testee.parseFromCentralDirectoryData(input, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)-81985529216486896L);
        }

        @Test
        void parseFromCentralDirectoryDataShouldHandleOffset() throws Exception {
            UidExtraField testee = new UidExtraField();
            byte[] input = Bytes.concat((byte[][])new byte[][]{UNUSED, _123456789ABCDEF0_AS_LE_BYTE_ARRAY});
            testee.parseFromCentralDirectoryData(input, 2, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)1311768467463790320L);
        }
    }

    @Nested
    class ParseFromLocalFileData {
        ParseFromLocalFileData() {
        }

        @Test
        void parseFromLocalFileDataShouldThrownWhenLengthIsSmallerThan8() {
            UidExtraField testee = new UidExtraField();
            byte[] input = new byte[]{0, 0, 0, 0, 0, 0, 0};
            Assertions.assertThatThrownBy(() -> testee.parseFromLocalFileData(input, 0, 7)).isInstanceOf(ZipException.class);
        }

        @Test
        void parseFromLocalFileDataShouldThrownWhenLengthIsBiggerThan8() {
            UidExtraField testee = new UidExtraField();
            byte[] input = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
            Assertions.assertThatThrownBy(() -> testee.parseFromLocalFileData(input, 0, 9)).isInstanceOf(ZipException.class);
        }

        @Test
        void parseFromLocalFileDataShouldParseWhenZero() throws Exception {
            UidExtraField testee = new UidExtraField();
            testee.parseFromLocalFileData(ZERO_AS_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)0L);
        }

        @Test
        void parseFromLocalFileDataShouldParseWhen123456789ABCDEF0InLittleEndian() throws Exception {
            UidExtraField testee = new UidExtraField();
            testee.parseFromLocalFileData(_123456789ABCDEF0_AS_LE_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)1311768467463790320L);
        }

        @Test
        void parseFromLocalFileDataShouldParseWhenFEDCBA9876543210InLittleEndian() throws Exception {
            UidExtraField testee = new UidExtraField();
            byte[] input = FEDCBA9876543210_AS_LE_BYTE_ARRAY;
            testee.parseFromLocalFileData(input, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)-81985529216486896L);
        }

        @Test
        void parseFromLocalFileDataShouldHandleOffset() throws Exception {
            UidExtraField testee = new UidExtraField();
            byte[] input = Bytes.concat((byte[][])new byte[][]{UNUSED, _123456789ABCDEF0_AS_LE_BYTE_ARRAY});
            testee.parseFromLocalFileData(input, 2, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)1311768467463790320L);
        }
    }

    @Nested
    class GetLocalFileDataData {
        GetLocalFileDataData() {
        }

        @Test
        void getLocalFileDataDataShouldThrowWhenNoValue() {
            UidExtraField testee = new UidExtraField();
            Assertions.assertThatThrownBy(() -> testee.getLocalFileDataData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getLocalFileDataDataShouldReturnZeroWhenZero() {
            byte[] actual = new UidExtraField(0L).getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)ZERO_AS_BYTE_ARRAY);
        }

        @Test
        void getLocalFileDataDataShouldReturnValueInLittleIndianWhen123456789ABCDEF0() {
            byte[] actual = new UidExtraField(1311768467463790320L).getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)_123456789ABCDEF0_AS_LE_BYTE_ARRAY);
        }

        @Test
        void getLocalFileDataDataShouldReturnValueInLittleIndianWhenFEDCBA9876543210() {
            byte[] actual = new UidExtraField(-81985529216486896L).getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)FEDCBA9876543210_AS_LE_BYTE_ARRAY);
        }
    }

    @Nested
    class GetCentralDirectoryLength {
        GetCentralDirectoryLength() {
        }

        @Test
        void getCentralDirectoryLengthShouldReturnIntegerSize() {
            UidExtraField testee = new UidExtraField();
            Assertions.assertThat((int)testee.getCentralDirectoryLength().getValue()).isEqualTo(8);
        }

        @Test
        void getCentralDirectoryDataShouldThrowWhenNoValue() {
            UidExtraField testee = new UidExtraField();
            Assertions.assertThatThrownBy(() -> testee.getCentralDirectoryData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getCentralDirectoryDataShouldReturnZeroWhenZero() {
            byte[] actual = new UidExtraField(0L).getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)ZERO_AS_BYTE_ARRAY);
        }

        @Test
        void getCentralDirectoryDataShouldReturnValueInLittleIndianWhen123456789ABCDEF0() {
            byte[] actual = new UidExtraField(1311768467463790320L).getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)_123456789ABCDEF0_AS_LE_BYTE_ARRAY);
        }

        @Test
        void getCentralDirectoryDataShouldReturnValueInLittleIndianWhenFEDCBA9876543210() {
            byte[] actual = new UidExtraField(-81985529216486896L).getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)FEDCBA9876543210_AS_LE_BYTE_ARRAY);
        }
    }

    @Nested
    class GetLocalFileDataLength {
        GetLocalFileDataLength() {
        }

        @Test
        void getLocalFileDataLengthShouldReturnIntegerSize() {
            UidExtraField testee = new UidExtraField();
            Assertions.assertThat((int)testee.getLocalFileDataLength().getValue()).isEqualTo(8);
        }
    }

    @Nested
    class GetHeaderId {
        GetHeaderId() {
        }

        @Test
        void getHeaderIdShouldReturnSpecificStringInLittleEndian() {
            UidExtraField testee = new UidExtraField();
            ByteBuffer byteBuffer = ByteBuffer.wrap(testee.getHeaderId().getBytes()).order(ByteOrder.LITTLE_ENDIAN);
            Assertions.assertThat((String)Charsets.US_ASCII.decode(byteBuffer).toString()).isEqualTo("ak");
        }
    }
}

