/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.james.mailbox.backup.zip.MessageIdExtraField;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class MessageIdExtraFieldTest {
    private static final String DEFAULT_MESSAGE_ID = "123456789ABCDEF0";
    private static final byte[] DEFAULT_MESSAGE_ID_BYTE_ARRAY = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 48};
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    MessageIdExtraFieldTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(MessageIdExtraField.class).suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }

    @Nested
    class ParseFromCentralDirectoryData {
        ParseFromCentralDirectoryData() {
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseWhenZero() {
            MessageIdExtraField testee = new MessageIdExtraField();
            testee.parseFromCentralDirectoryData(EMPTY_BYTE_ARRAY, 0, 0);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"");
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseByteArray() {
            MessageIdExtraField testee = new MessageIdExtraField();
            testee.parseFromCentralDirectoryData(DEFAULT_MESSAGE_ID_BYTE_ARRAY, 0, 16);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)MessageIdExtraFieldTest.DEFAULT_MESSAGE_ID);
        }

        @Test
        void parseFromCentralDirectoryDataShouldHandleOffset() {
            MessageIdExtraField testee = new MessageIdExtraField();
            testee.parseFromCentralDirectoryData(DEFAULT_MESSAGE_ID_BYTE_ARRAY, 2, 14);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"3456789ABCDEF0");
        }
    }

    @Nested
    class ParseFromLocalFileData {
        ParseFromLocalFileData() {
        }

        @Test
        void parseFromLocalFileDataShouldParseWhenZero() {
            MessageIdExtraField testee = new MessageIdExtraField();
            testee.parseFromLocalFileData(EMPTY_BYTE_ARRAY, 0, 0);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"");
        }

        @Test
        void parseFromLocalFileDataShouldParseByteArray() {
            MessageIdExtraField testee = new MessageIdExtraField();
            testee.parseFromLocalFileData(DEFAULT_MESSAGE_ID_BYTE_ARRAY, 0, 16);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)MessageIdExtraFieldTest.DEFAULT_MESSAGE_ID);
        }

        @Test
        void parseFromLocalFileDataShouldHandleOffset() {
            MessageIdExtraField testee = new MessageIdExtraField();
            testee.parseFromLocalFileData(DEFAULT_MESSAGE_ID_BYTE_ARRAY, 2, 14);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"3456789ABCDEF0");
        }
    }

    @Nested
    class GetCentralDirectoryData {
        GetCentralDirectoryData() {
        }

        @Test
        void getCentralDirectoryDataShouldThrowWhenNoValue() {
            MessageIdExtraField testee = new MessageIdExtraField();
            Assertions.assertThatThrownBy(() -> testee.getCentralDirectoryData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getCentralDirectoryDataShouldReturnEmptyArrayWhenValueIsEmpty() {
            byte[] actual = new MessageIdExtraField("").getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)EMPTY_BYTE_ARRAY);
        }

        @Test
        void getCentralDirectoryDataShouldReturnValueInByteArray() {
            byte[] actual = new MessageIdExtraField(MessageIdExtraFieldTest.DEFAULT_MESSAGE_ID).getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)DEFAULT_MESSAGE_ID_BYTE_ARRAY);
        }
    }

    @Nested
    class GetLocalFileDataData {
        GetLocalFileDataData() {
        }

        @Test
        void getLocalFileDataDataShouldThrowWhenNoValue() {
            MessageIdExtraField testee = new MessageIdExtraField();
            Assertions.assertThatThrownBy(() -> testee.getLocalFileDataData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getLocalFileDataDataShouldReturnEmptyArrayWhenValueIsEmpty() {
            byte[] actual = new MessageIdExtraField("").getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)EMPTY_BYTE_ARRAY);
        }

        @Test
        void getLocalFileDataDataShouldReturnValueInByteArray() {
            byte[] actual = new MessageIdExtraField(MessageIdExtraFieldTest.DEFAULT_MESSAGE_ID).getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)DEFAULT_MESSAGE_ID_BYTE_ARRAY);
        }
    }

    @Nested
    class GetCentralDirectoryLength {
        GetCentralDirectoryLength() {
        }

        @Test
        void getCentralDirectoryLengthShouldThrowWhenNoValue() {
            MessageIdExtraField testee = new MessageIdExtraField();
            Assertions.assertThatThrownBy(() -> testee.getCentralDirectoryLength().getValue()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getCentralDirectoryLengthShouldReturnIntegerSize() {
            MessageIdExtraField testee = new MessageIdExtraField(MessageIdExtraFieldTest.DEFAULT_MESSAGE_ID);
            Assertions.assertThat((int)testee.getCentralDirectoryLength().getValue()).isEqualTo(16);
        }
    }

    @Nested
    class GetLocalFileDataLength {
        GetLocalFileDataLength() {
        }

        @Test
        void getLocalFileDataLengthShouldThrowWhenNoValue() {
            MessageIdExtraField testee = new MessageIdExtraField();
            Assertions.assertThatThrownBy(() -> testee.getLocalFileDataLength().getValue()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getLocalFileDataLengthShouldReturnIntegerSize() {
            MessageIdExtraField testee = new MessageIdExtraField(MessageIdExtraFieldTest.DEFAULT_MESSAGE_ID);
            Assertions.assertThat((int)testee.getLocalFileDataLength().getValue()).isEqualTo(16);
        }
    }

    @Nested
    class GetHeaderId {
        GetHeaderId() {
        }

        @Test
        void getHeaderIdShouldReturnSpecificStringInLittleEndian() {
            MessageIdExtraField testee = new MessageIdExtraField();
            ByteBuffer byteBuffer = ByteBuffer.wrap(testee.getHeaderId().getBytes()).order(ByteOrder.LITTLE_ENDIAN);
            Assertions.assertThat((String)Charsets.US_ASCII.decode(byteBuffer).toString()).isEqualTo("al");
        }
    }
}

