/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionUtil;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.backup.SerializedMailboxId;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;

public interface MailboxMessageFixture {
    public static final Username USER = Username.of((String)"user");
    public static final Username OTHER_USER = Username.of((String)"otherUser");
    public static final Username USERNAME_1 = USER;
    public static final Username USERNAME_2 = OTHER_USER;
    public static final String DATE_STRING_1 = "2018-02-15T15:54:02Z";
    public static final String DATE_STRING_2 = "2018-03-15T15:54:02Z";
    public static final ZonedDateTime DATE_1 = ZonedDateTime.parse("2018-02-15T15:54:02Z");
    public static final ZonedDateTime DATE_2 = ZonedDateTime.parse("2018-03-15T15:54:02Z");
    public static final MessageId.Factory MESSAGE_ID_FACTORY = new TestMessageId.Factory();
    public static final Charset MESSAGE_CHARSET = StandardCharsets.UTF_8;
    public static final String MESSAGE_CONTENT_1 = "Simple message content";
    public static final byte[] MESSAGE_CONTENT_BYTES_1 = "Simple message content".getBytes(MESSAGE_CHARSET);
    public static final ByteContent CONTENT_STREAM_1 = new ByteContent(MESSAGE_CONTENT_BYTES_1);
    public static final String MESSAGE_CONTENT_2 = "Other message content";
    public static final byte[] MESSAGE_CONTENT_BYTES_2 = "Other message content".getBytes(MESSAGE_CHARSET);
    public static final ByteContent CONTENT_STREAM_2 = new ByteContent(MESSAGE_CONTENT_BYTES_2);
    public static final MessageId MESSAGE_ID_1 = MESSAGE_ID_FACTORY.generate();
    public static final MessageId MESSAGE_ID_2 = MESSAGE_ID_FACTORY.generate();
    public static final MessageId MESSAGE_ID_OTHER_USER_1 = MESSAGE_ID_FACTORY.generate();
    public static final long SIZE_1 = MESSAGE_CONTENT_BYTES_1.length;
    public static final long SIZE_2 = MESSAGE_CONTENT_BYTES_2.length;
    public static final long MESSAGE_UID_1_VALUE = 1111L;
    public static final long MESSAGE_UID_2_VALUE = 2222L;
    public static final long MESSAGE_UID_OTHER_USER_1_VALUE = 1111L;
    public static final MessageUid MESSAGE_UID_1 = MessageUid.of((long)1111L);
    public static final MessageUid MESSAGE_UID_2 = MessageUid.of((long)2222L);
    public static final MessageUid MESSAGE_UID_OTHER_USER_1 = MessageUid.of((long)1111L);
    public static final MailboxId MAILBOX_ID_1 = TestId.of((long)1L);
    public static final MailboxId MAILBOX_ID_2 = TestId.of((long)2L);
    public static final MailboxId MAILBOX_ID_11 = TestId.of((long)11L);
    public static final SerializedMailboxId SERIALIZED_MAILBOX_ID_1 = SerializedMailboxId.from((MailboxId)MAILBOX_ID_1);
    public static final SerializedMailboxId SERIALIZED_MAILBOX_ID_2 = SerializedMailboxId.from((MailboxId)MAILBOX_ID_2);
    public static final Flags flags1 = new Flags("myFlags");
    public static final MailboxSession MAILBOX_SESSION = MailboxSessionUtil.create((Username)USER);
    public static final String MAILBOX_1_NAME = "mailbox1";
    public static final String MAILBOX_2_NAME = "mailbox2";
    public static final String MAILBOX_OTHER_USER_NAME = "mailbox_other";
    public static final MailboxPath MAILBOX_PATH_USER1_MAILBOX1 = MailboxPath.forUser((Username)USER, (String)"mailbox1");
    public static final MailboxPath MAILBOX_PATH_USER1_MAILBOX1_SUB_1 = MailboxPath.forUser((Username)USER, (String)("mailbox1" + MAILBOX_SESSION.getPathDelimiter() + "sub1"));
    public static final MailboxPath MAILBOX_PATH_USER1_MAILBOX2 = MailboxPath.forUser((Username)USER, (String)"mailbox2");
    public static final MailboxPath MAILBOX_PATH_OTHER_USER_MAILBOX1 = MailboxPath.forUser((Username)OTHER_USER, (String)"mailbox_other");
    public static final Mailbox MAILBOX_1 = new Mailbox(MAILBOX_PATH_USER1_MAILBOX1, UidValidity.of((long)42L), MAILBOX_ID_1);
    public static final Mailbox MAILBOX_1_OTHER_USER = new Mailbox(MAILBOX_PATH_OTHER_USER_MAILBOX1, UidValidity.of((long)42L), MAILBOX_ID_11);
    public static final Mailbox MAILBOX_1_SUB_1 = new Mailbox(MAILBOX_PATH_USER1_MAILBOX1_SUB_1, UidValidity.of((long)420L), (MailboxId)TestId.of((long)11L));
    public static final Mailbox MAILBOX_2 = new Mailbox(MAILBOX_PATH_USER1_MAILBOX2, UidValidity.of((long)43L), MAILBOX_ID_2);
    public static final List<MailboxAnnotation> NO_ANNOTATION = ImmutableList.of();
    public static final MailboxAnnotationKey ANNOTATION_1_KEY = new MailboxAnnotationKey("/annotation1/test");
    public static final MailboxAnnotationKey ANNOTATION_2_KEY = new MailboxAnnotationKey("/annotation2/void");
    public static final String ANNOTATION_1_CONTENT = "annotation1 content";
    public static final String ANNOTATION_1_BIS_CONTENT = "annotation1 bis content";
    public static final String ANNOTATION_2_CONTENT = "annotation2 content";
    public static final MailboxAnnotation ANNOTATION_1 = MailboxAnnotation.newInstance((MailboxAnnotationKey)ANNOTATION_1_KEY, (String)"annotation1 content");
    public static final MailboxAnnotation ANNOTATION_1_BIS = MailboxAnnotation.newInstance((MailboxAnnotationKey)ANNOTATION_1_KEY, (String)"annotation1 bis content");
    public static final List<MailboxAnnotation> WITH_ANNOTATION_1 = ImmutableList.of((Object)ANNOTATION_1);
    public static final MailboxAnnotation ANNOTATION_2 = MailboxAnnotation.newInstance((MailboxAnnotationKey)ANNOTATION_2_KEY, (String)"annotation2 content");
    public static final List<MailboxAnnotation> WITH_ANNOTATION_1_AND_2 = ImmutableList.of((Object)ANNOTATION_1, (Object)ANNOTATION_2);
    public static final SimpleMailboxMessage MESSAGE_1 = SimpleMailboxMessage.builder().messageId(MESSAGE_ID_1).threadId(ThreadId.fromBaseMessageId((MessageId)MESSAGE_ID_1)).uid(MESSAGE_UID_1).content((Content)CONTENT_STREAM_1).size(SIZE_1).internalDate(new Date(DATE_1.toEpochSecond())).bodyStartOctet(0).flags(flags1).properties(new PropertyBuilder()).mailboxId(MAILBOX_ID_1).build();
    public static final SimpleMailboxMessage MESSAGE_1_OTHER_USER = SimpleMailboxMessage.builder().messageId(MESSAGE_ID_OTHER_USER_1).threadId(ThreadId.fromBaseMessageId((MessageId)MESSAGE_ID_OTHER_USER_1)).uid(MESSAGE_UID_OTHER_USER_1).content((Content)CONTENT_STREAM_1).size(SIZE_1).internalDate(new Date(DATE_1.toEpochSecond())).bodyStartOctet(0).flags(flags1).properties(new PropertyBuilder()).mailboxId(MAILBOX_ID_11).build();
    public static final SimpleMailboxMessage MESSAGE_2 = SimpleMailboxMessage.builder().messageId(MESSAGE_ID_2).threadId(ThreadId.fromBaseMessageId((MessageId)MESSAGE_ID_2)).uid(MESSAGE_UID_2).content((Content)CONTENT_STREAM_2).size(SIZE_2).internalDate(new Date(DATE_2.toEpochSecond())).bodyStartOctet(0).flags(new Flags()).properties(new PropertyBuilder()).mailboxId(MAILBOX_ID_1).build();
}

