/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.james.mailbox.backup.zip.MailboxIdExtraField;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class MailboxIdExtraFieldTest {
    private static final String DEFAULT_MAILBOX_ID = "123456789ABCDEF0";
    private static final byte[] DEFAULT_MAILBOX_ID_BYTE_ARRAY = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 48};
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    MailboxIdExtraFieldTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxIdExtraField.class).suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }

    @Nested
    class ParseFromCentralDirectoryData {
        ParseFromCentralDirectoryData() {
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseWhenZero() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            testee.parseFromCentralDirectoryData(EMPTY_BYTE_ARRAY, 0, 0);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"");
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseByteArray() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            testee.parseFromCentralDirectoryData(DEFAULT_MAILBOX_ID_BYTE_ARRAY, 0, 16);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)MailboxIdExtraFieldTest.DEFAULT_MAILBOX_ID);
        }

        @Test
        void parseFromCentralDirectoryDataShouldHandleOffset() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            testee.parseFromCentralDirectoryData(DEFAULT_MAILBOX_ID_BYTE_ARRAY, 2, 14);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"3456789ABCDEF0");
        }
    }

    @Nested
    class ParseFromLocalFileData {
        ParseFromLocalFileData() {
        }

        @Test
        void parseFromLocalFileDataShouldParseWhenZero() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            testee.parseFromLocalFileData(EMPTY_BYTE_ARRAY, 0, 0);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"");
        }

        @Test
        void parseFromLocalFileDataShouldParseByteArray() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            testee.parseFromLocalFileData(DEFAULT_MAILBOX_ID_BYTE_ARRAY, 0, 16);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)MailboxIdExtraFieldTest.DEFAULT_MAILBOX_ID);
        }

        @Test
        void parseFromLocalFileDataShouldHandleOffset() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            testee.parseFromLocalFileData(DEFAULT_MAILBOX_ID_BYTE_ARRAY, 2, 14);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"3456789ABCDEF0");
        }
    }

    @Nested
    class GetCentralDirectoryData {
        GetCentralDirectoryData() {
        }

        @Test
        void getCentralDirectoryDataShouldThrowWhenNoValue() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            Assertions.assertThatThrownBy(() -> testee.getCentralDirectoryData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getCentralDirectoryDataShouldReturnEmptyArrayWhenValueIsEmpty() {
            byte[] actual = new MailboxIdExtraField("").getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)EMPTY_BYTE_ARRAY);
        }

        @Test
        void getCentralDirectoryDataShouldReturnValueInByteArray() {
            byte[] actual = new MailboxIdExtraField(MailboxIdExtraFieldTest.DEFAULT_MAILBOX_ID).getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)DEFAULT_MAILBOX_ID_BYTE_ARRAY);
        }
    }

    @Nested
    class GetLocalFileDataData {
        GetLocalFileDataData() {
        }

        @Test
        void getLocalFileDataDataShouldThrowWhenNoValue() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            Assertions.assertThatThrownBy(() -> testee.getLocalFileDataData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getLocalFileDataDataShouldReturnEmptyArrayWhenValueIsEmpty() {
            byte[] actual = new MailboxIdExtraField("").getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)EMPTY_BYTE_ARRAY);
        }

        @Test
        void getLocalFileDataDataShouldReturnValueInByteArray() {
            byte[] actual = new MailboxIdExtraField(MailboxIdExtraFieldTest.DEFAULT_MAILBOX_ID).getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)DEFAULT_MAILBOX_ID_BYTE_ARRAY);
        }
    }

    @Nested
    class GetCentralDirectoryLength {
        GetCentralDirectoryLength() {
        }

        @Test
        void getCentralDirectoryLengthShouldThrowWhenNoValue() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            Assertions.assertThatThrownBy(() -> testee.getCentralDirectoryLength().getValue()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getCentralDirectoryLengthShouldReturnIntegerSize() {
            MailboxIdExtraField testee = new MailboxIdExtraField(MailboxIdExtraFieldTest.DEFAULT_MAILBOX_ID);
            Assertions.assertThat((int)testee.getCentralDirectoryLength().getValue()).isEqualTo(16);
        }
    }

    @Nested
    class GetLocalFileDataLength {
        GetLocalFileDataLength() {
        }

        @Test
        void getLocalFileDataLengthShouldThrowWhenNoValue() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            Assertions.assertThatThrownBy(() -> testee.getLocalFileDataLength().getValue()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getLocalFileDataLengthShouldReturnIntegerSize() {
            MailboxIdExtraField testee = new MailboxIdExtraField(MailboxIdExtraFieldTest.DEFAULT_MAILBOX_ID);
            Assertions.assertThat((int)testee.getLocalFileDataLength().getValue()).isEqualTo(16);
        }
    }

    @Nested
    class GetHeaderId {
        GetHeaderId() {
        }

        @Test
        void getHeaderIdShouldReturnSpecificStringInLittleEndian() {
            MailboxIdExtraField testee = new MailboxIdExtraField();
            ByteBuffer byteBuffer = ByteBuffer.wrap(testee.getHeaderId().getBytes()).order(ByteOrder.LITTLE_ENDIAN);
            Assertions.assertThat((String)Charsets.US_ASCII.decode(byteBuffer).toString()).isEqualTo("am");
        }
    }
}

