/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.base.Charsets;
import com.google.common.primitives.Bytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.Optional;
import java.util.zip.ZipException;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.james.mailbox.backup.zip.InternalDateExtraField;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class InternalDateExtraFieldTest {
    private static final byte[] ZERO_AS_BYTE_ARRAY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] _123456789ABCDEF0_AS_LE_BYTE_ARRAY = new byte[]{-16, -34, -68, -102, 120, 86, 52, 18};
    private static final byte[] FEDCBA9876543210_AS_LE_BYTE_ARRAY = new byte[]{16, 50, 84, 118, -104, -70, -36, -2};
    private static final byte[] UNUSED = new byte[]{-34, -83};
    private static final long DEFAULT_DATE_TIMESTAMP = 1529559708381L;
    private static final byte[] DEFAULT_DATE_LE_BYTE_ARRAY = new byte[]{-35, -14, -36, 32, 100, 1, 0, 0};
    private static final Date DEFAULT_DATE = new Date(1529559708381L);

    InternalDateExtraFieldTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(InternalDateExtraField.class).suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }

    @Nested
    class ParseFromCentralDirectoryData {
        ParseFromCentralDirectoryData() {
        }

        @Test
        void parseFromCentralDirectoryDataShouldThrownWhenLengthIsSmallerThan8() {
            InternalDateExtraField testee = new InternalDateExtraField();
            byte[] input = new byte[7];
            Assertions.assertThatThrownBy(() -> testee.parseFromCentralDirectoryData(input, 0, 7)).isInstanceOf(ZipException.class);
        }

        @Test
        void parseFromCentralDirectoryDataShouldThrownWhenLengthIsBiggerThan8() {
            InternalDateExtraField testee = new InternalDateExtraField();
            byte[] input = new byte[9];
            Assertions.assertThatThrownBy(() -> testee.parseFromCentralDirectoryData(input, 0, 9)).isInstanceOf(ZipException.class);
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseWhenZero() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            testee.parseFromCentralDirectoryData(ZERO_AS_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)0L);
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseWhen123456789ABCDEF0InLittleEndian() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            testee.parseFromCentralDirectoryData(_123456789ABCDEF0_AS_LE_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)1311768467463790320L);
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseWhenFEDCBA9876543210InLittleEndian() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            byte[] input = FEDCBA9876543210_AS_LE_BYTE_ARRAY;
            testee.parseFromCentralDirectoryData(input, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)-81985529216486896L);
        }

        @Test
        void parseFromCentralDirectoryDataShouldHandleOffset() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            byte[] input = Bytes.concat((byte[][])new byte[][]{UNUSED, _123456789ABCDEF0_AS_LE_BYTE_ARRAY});
            testee.parseFromCentralDirectoryData(input, 2, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)1311768467463790320L);
        }

        @Test
        void parseFromCentralDirectoryDataShouldReturnZeroDayWhenZero() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            testee.parseFromCentralDirectoryData(ZERO_AS_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getDateValue()).contains((Object)new Date(0L));
        }

        @Test
        void parseFromCentralDirectoryDataShouldReturnDefaultDateWhenPassDefaultUTCDateByteArray() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            testee.parseFromCentralDirectoryData(DEFAULT_DATE_LE_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getDateValue()).contains((Object)DEFAULT_DATE);
        }
    }

    @Nested
    class ParseFromLocalFileData {
        ParseFromLocalFileData() {
        }

        @Test
        void parseFromLocalFileDataShouldThrownWhenLengthIsSmallerThan8() {
            InternalDateExtraField testee = new InternalDateExtraField();
            byte[] input = new byte[]{0, 0, 0, 0, 0, 0, 0};
            Assertions.assertThatThrownBy(() -> testee.parseFromLocalFileData(input, 0, 7)).isInstanceOf(ZipException.class);
        }

        @Test
        void parseFromLocalFileDataShouldThrownWhenLengthIsBiggerThan8() {
            InternalDateExtraField testee = new InternalDateExtraField();
            byte[] input = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
            Assertions.assertThatThrownBy(() -> testee.parseFromLocalFileData(input, 0, 9)).isInstanceOf(ZipException.class);
        }

        @Test
        void parseFromLocalFileDataShouldParseWhenZero() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            testee.parseFromLocalFileData(ZERO_AS_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)0L);
        }

        @Test
        void parseFromLocalFileDataShouldParseWhen123456789ABCDEF0InLittleEndian() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            testee.parseFromLocalFileData(_123456789ABCDEF0_AS_LE_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)1311768467463790320L);
        }

        @Test
        void parseFromLocalFileDataShouldParseWhenFEDCBA9876543210InLittleEndian() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            byte[] input = FEDCBA9876543210_AS_LE_BYTE_ARRAY;
            testee.parseFromLocalFileData(input, 0, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)-81985529216486896L);
        }

        @Test
        void parseFromLocalFileDataShouldHandleOffset() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            byte[] input = Bytes.concat((byte[][])new byte[][]{UNUSED, _123456789ABCDEF0_AS_LE_BYTE_ARRAY});
            testee.parseFromLocalFileData(input, 2, 8);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)1311768467463790320L);
        }

        @Test
        void parseFromLocalFileDataShouldReturnZeroDayWhenZero() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            testee.parseFromLocalFileData(ZERO_AS_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getDateValue()).contains((Object)new Date(0L));
        }

        @Test
        void parseFromLocalFileDataShouldReturnDefaultDateWhenPassDefaultUTCDateByteArray() throws Exception {
            InternalDateExtraField testee = new InternalDateExtraField();
            testee.parseFromLocalFileData(DEFAULT_DATE_LE_BYTE_ARRAY, 0, 8);
            Assertions.assertThat((Optional)testee.getDateValue()).contains((Object)DEFAULT_DATE);
        }
    }

    @Nested
    class GetLocalFileDataData {
        GetLocalFileDataData() {
        }

        @Test
        void getLocalFileDataDataShouldThrowWhenNoValue() {
            InternalDateExtraField testee = new InternalDateExtraField();
            Assertions.assertThatThrownBy(() -> testee.getLocalFileDataData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getLocalFileDataDataShouldReturnZeroWhenZero() {
            byte[] actual = new InternalDateExtraField(0L).getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)ZERO_AS_BYTE_ARRAY);
        }

        @Test
        void getLocalFileDataDataShouldReturnValueInLittleIndianWhen123456789ABCDEF0() {
            byte[] actual = new InternalDateExtraField(1311768467463790320L).getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)_123456789ABCDEF0_AS_LE_BYTE_ARRAY);
        }

        @Test
        void getLocalFileDataDataShouldReturnValueInLittleIndianWhenFEDCBA9876543210() {
            byte[] actual = new InternalDateExtraField(-81985529216486896L).getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)FEDCBA9876543210_AS_LE_BYTE_ARRAY);
        }

        @Test
        void getLocalFileDataDataShouldReturnDefaultDateWhenPassDefaultDateInByteArray() {
            byte[] actual = new InternalDateExtraField(DEFAULT_DATE).getLocalFileDataData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)DEFAULT_DATE_LE_BYTE_ARRAY);
        }
    }

    @Nested
    class GetCentralDirectoryLength {
        GetCentralDirectoryLength() {
        }

        @Test
        void getCentralDirectoryLengthShouldReturnIntegerSize() {
            InternalDateExtraField testee = new InternalDateExtraField();
            Assertions.assertThat((int)testee.getCentralDirectoryLength().getValue()).isEqualTo(8);
        }

        @Test
        void getCentralDirectoryDataShouldThrowWhenNoValue() {
            InternalDateExtraField testee = new InternalDateExtraField();
            Assertions.assertThatThrownBy(() -> testee.getCentralDirectoryData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getCentralDirectoryDataShouldReturnZeroWhenZero() {
            byte[] actual = new InternalDateExtraField(0L).getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)ZERO_AS_BYTE_ARRAY);
        }

        @Test
        void getCentralDirectoryDataShouldReturnValueInLittleIndianWhen123456789ABCDEF0() {
            byte[] actual = new InternalDateExtraField(1311768467463790320L).getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)_123456789ABCDEF0_AS_LE_BYTE_ARRAY);
        }

        @Test
        void getCentralDirectoryDataShouldReturnValueInLittleIndianWhenFEDCBA9876543210() {
            byte[] actual = new InternalDateExtraField(-81985529216486896L).getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)FEDCBA9876543210_AS_LE_BYTE_ARRAY);
        }

        @Test
        void getCentralDirectoryDataShouldReturnDefaultDateWhenPassDefaultDateInByteArray() {
            byte[] actual = new InternalDateExtraField(DEFAULT_DATE).getCentralDirectoryData();
            Assertions.assertThat((byte[])actual).isEqualTo((Object)DEFAULT_DATE_LE_BYTE_ARRAY);
        }
    }

    @Nested
    class GetLocalFileDataLength {
        GetLocalFileDataLength() {
        }

        @Test
        void getLocalFileDataLengthShouldReturnIntegerSize() {
            InternalDateExtraField testee = new InternalDateExtraField();
            Assertions.assertThat((int)testee.getLocalFileDataLength().getValue()).isEqualTo(8);
        }
    }

    @Nested
    class GetHeaderId {
        GetHeaderId() {
        }

        @Test
        void getHeaderIdShouldReturnSpecificStringInLittleEndian() {
            InternalDateExtraField testee = new InternalDateExtraField();
            ByteBuffer byteBuffer = ByteBuffer.wrap(testee.getHeaderId().getBytes()).order(ByteOrder.LITTLE_ENDIAN);
            Assertions.assertThat((String)Charsets.US_ASCII.decode(byteBuffer).toString()).isEqualTo("ao");
        }
    }
}

