/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.mail.Flags;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.james.mailbox.backup.zip.FlagsExtraField;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class FlagExtraFieldTest {
    FlagExtraFieldTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(FlagsExtraField.class).suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }

    @Nested
    class ParseFromCentralDirectoryData {
        ParseFromCentralDirectoryData() {
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseByteData() {
            String bufferContent = "\\ANSWERED%\\SEEN%myFlags";
            Flags flags = new Flags("myFlags");
            flags.add(Flags.Flag.ANSWERED);
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(new Flags());
            testee.parseFromCentralDirectoryData(bufferContent.getBytes(StandardCharsets.UTF_8), 0, 23);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)bufferContent);
        }

        @Test
        void parseFromCentralDirectoryDataShouldParseByteDataWhenOffsetSet() {
            String bufferContent = "\\ANSWERED%\\SEEN%myFlags";
            Flags flags = new Flags("myFlags");
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(new Flags());
            testee.parseFromCentralDirectoryData(bufferContent.getBytes(StandardCharsets.UTF_8), 10, 13);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"\\SEEN%myFlags");
        }
    }

    @Nested
    class ParseFromLocalFileData {
        ParseFromLocalFileData() {
        }

        @Test
        void parseFromLocalFileDataShouldParseByteData() {
            String bufferContent = "\\ANSWERED%\\SEEN%myFlags";
            Flags flags = new Flags("myFlags");
            flags.add(Flags.Flag.ANSWERED);
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(new Flags());
            testee.parseFromLocalFileData(bufferContent.getBytes(StandardCharsets.UTF_8), 0, 23);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)bufferContent);
        }

        @Test
        void parseFromLocalFileDataShouldParseByteDataWhenOffsetSet() {
            String bufferContent = "\\ANSWERED%\\SEEN%myFlags";
            Flags flags = new Flags("myFlags");
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(new Flags());
            testee.parseFromLocalFileData(bufferContent.getBytes(StandardCharsets.UTF_8), 10, 13);
            Assertions.assertThat((Optional)testee.getValue()).contains((Object)"\\SEEN%myFlags");
        }
    }

    @Nested
    class GetCentralDirectoryData {
        GetCentralDirectoryData() {
        }

        @Test
        void getCentralDirectoryDataShouldThrowWhenNoValue() {
            FlagsExtraField testee = new FlagsExtraField();
            Assertions.assertThatThrownBy(() -> testee.getCentralDirectoryData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getCentralDirectoryDataShouldReturnByteArraysOfSystemFlagSet() {
            Flags flags = new Flags();
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((byte[])testee.getCentralDirectoryData()).isEqualTo((Object)"\\SEEN".getBytes(StandardCharsets.UTF_8));
        }

        @Test
        void getCentralDirectoryDataShouldReturnByteArrayOfUserFlagSet() {
            Flags flags = new Flags("myFlags");
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((byte[])testee.getCentralDirectoryData()).isEqualTo((Object)"myFlags".getBytes(StandardCharsets.UTF_8));
        }

        @Test
        void getCentralDirectoryDataShouldReturnByteArrayOfSystemAndUserFlagSet() {
            Flags flags = new Flags("myFlags");
            flags.add(Flags.Flag.ANSWERED);
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((byte[])testee.getCentralDirectoryData()).isEqualTo((Object)"\\ANSWERED%\\SEEN%myFlags".getBytes(StandardCharsets.UTF_8));
        }
    }

    @Nested
    class GetLocalFileData {
        GetLocalFileData() {
        }

        @Test
        void getLocalFileDataDataShouldThrowWhenNoValue() {
            FlagsExtraField testee = new FlagsExtraField();
            Assertions.assertThatThrownBy(() -> testee.getLocalFileDataData()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getLocalFileDataDataShouldReturnByteArraysOfSystemFlagSet() {
            Flags flags = new Flags();
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((byte[])testee.getLocalFileDataData()).isEqualTo((Object)"\\SEEN".getBytes(StandardCharsets.UTF_8));
        }

        @Test
        void getLocalFileDataDataShouldReturnByteArrayOfUserFlagSet() {
            Flags flags = new Flags("myFlags");
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((byte[])testee.getLocalFileDataData()).isEqualTo((Object)"myFlags".getBytes(StandardCharsets.UTF_8));
        }

        @Test
        void getLocalFileDataDataShouldReturnByteArrayOfSystemAndUserFlagSet() {
            Flags flags = new Flags("myFlags");
            flags.add(Flags.Flag.ANSWERED);
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((byte[])testee.getLocalFileDataData()).isEqualTo((Object)"\\ANSWERED%\\SEEN%myFlags".getBytes(StandardCharsets.UTF_8));
        }
    }

    @Nested
    class GetCentralDirectoryLength {
        GetCentralDirectoryLength() {
        }

        @Test
        void getCentralDirectoryLengthShouldThrowWhenNoValue() {
            FlagsExtraField testee = new FlagsExtraField();
            Assertions.assertThatThrownBy(() -> testee.getCentralDirectoryLength().getValue()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getCentralDirectoryLengthShouldReturnIntegerSize() {
            FlagsExtraField testee = new FlagsExtraField(new Flags());
            Assertions.assertThat((int)testee.getCentralDirectoryLength().getValue()).isEqualTo(0);
        }

        @Test
        void getCentralDirectoryLengthShouldReturnIntegerSizeWhenSystemFlagSet() {
            Flags flags = new Flags();
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((int)testee.getCentralDirectoryLength().getValue()).isEqualTo(5);
        }

        @Test
        void getCentralDirectoryLengthShouldReturnIntegerSizeWhenUserFlagSet() {
            Flags flags = new Flags("myFlags");
            flags.add("newFlag");
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((int)testee.getCentralDirectoryLength().getValue()).isEqualTo(15);
        }

        @Test
        void getLocalFileDataLengthShouldReturnIntegerSizeWhenSystemAndUserFlagSet() {
            Flags flags = new Flags("myFlags");
            flags.add(Flags.Flag.ANSWERED);
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((int)testee.getCentralDirectoryLength().getValue()).isEqualTo(23);
        }
    }

    @Nested
    class GetLocalFileDataLength {
        GetLocalFileDataLength() {
        }

        @Test
        void getLocalFileDataLengthShouldThrowWhenNoValue() {
            FlagsExtraField testee = new FlagsExtraField();
            Assertions.assertThatThrownBy(() -> testee.getLocalFileDataLength().getValue()).isInstanceOf(RuntimeException.class);
        }

        @Test
        void getLocalFileDataLengthShouldReturnIntegerSize() {
            FlagsExtraField testee = new FlagsExtraField(new Flags());
            Assertions.assertThat((int)testee.getLocalFileDataLength().getValue()).isEqualTo(0);
        }

        @Test
        void getLocalFileDataLengthShouldReturnIntegerSizeWhenSystemFlagSet() {
            Flags flags = new Flags();
            flags.add(Flags.Flag.SEEN);
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((int)testee.getLocalFileDataLength().getValue()).isEqualTo(5);
        }

        @Test
        void getLocalFileDataLengthShouldReturnIntegerSizeWhenUserFlagSet() {
            Flags flags = new Flags("myFlags");
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((int)testee.getLocalFileDataLength().getValue()).isEqualTo(7);
        }

        @Test
        void getLocalFileDataLengthShouldReturnIntegerSizeWhenSystemAndUserFlagSet() {
            Flags flags = new Flags("myFlags");
            flags.add(Flags.Flag.ANSWERED);
            FlagsExtraField testee = new FlagsExtraField(flags);
            Assertions.assertThat((int)testee.getLocalFileDataLength().getValue()).isEqualTo(17);
        }
    }

    @Nested
    class GetHeaderId {
        GetHeaderId() {
        }

        @Test
        void getHeaderIdShouldReturnSpecificStringInLittleEndian() {
            FlagsExtraField testee = new FlagsExtraField();
            ByteBuffer byteBuffer = ByteBuffer.wrap(testee.getHeaderId().getBytes()).order(ByteOrder.LITTLE_ENDIAN);
            Assertions.assertThat((String)Charsets.US_ASCII.decode(byteBuffer).toString()).isEqualTo("ap");
        }
    }
}

