/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.github.fge.lambdas.Throwing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.backup.ArchiveService;
import org.apache.james.mailbox.backup.DefaultMailboxBackup;
import org.apache.james.mailbox.backup.MailArchiveRestorer;
import org.apache.james.mailbox.backup.MailArchivesLoader;
import org.apache.james.mailbox.backup.MailboxBackup;
import org.apache.james.mailbox.backup.MailboxMessageFixture;
import org.apache.james.mailbox.backup.ZipAssert;
import org.apache.james.mailbox.backup.ZipMailArchiveRestorer;
import org.apache.james.mailbox.backup.zip.ZipArchivesLoader;
import org.apache.james.mailbox.backup.zip.Zipper;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.model.ByteSourceContent;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class DefaultMailboxBackupTest
implements MailboxMessageFixture {
    private static final int BUFFER_SIZE = 4096;
    private static final String EXPECTED_ANNOTATIONS_DIR = "annotations";
    private final ArchiveService archiveService = new Zipper();
    private final MailArchivesLoader archiveLoader = new ZipArchivesLoader();
    private MailArchiveRestorer archiveRestorer;
    private MailboxManager mailboxManager;
    private DefaultMailboxBackup backup;
    private MailboxSession sessionUser;
    private MailboxSession sessionOtherUser;

    DefaultMailboxBackupTest() {
    }

    @BeforeEach
    void beforeEach() throws Exception {
        this.mailboxManager = InMemoryIntegrationResources.defaultResources().getMailboxManager();
        this.archiveRestorer = new ZipMailArchiveRestorer(this.mailboxManager, this.archiveLoader);
        this.backup = new DefaultMailboxBackup(this.mailboxManager, this.archiveService, this.archiveRestorer);
        this.sessionUser = this.mailboxManager.createSystemSession(USER);
        this.sessionOtherUser = this.mailboxManager.createSystemSession(OTHER_USER);
    }

    private void createMailboxWithMessages(MailboxSession session, MailboxPath mailboxPath, MessageManager.AppendCommand ... messages) throws Exception {
        MailboxId mailboxId = (MailboxId)this.mailboxManager.createMailbox(mailboxPath, session).get();
        Arrays.stream(messages).forEach((Consumer<MessageManager.AppendCommand>)Throwing.consumer(message -> this.mailboxManager.getMailbox(mailboxId, session).appendMessage(message, session)));
    }

    private void createMailbox(MailboxSession session, MailboxPath mailboxPath) throws Exception {
        this.createMailboxWithMessages(session, mailboxPath, new MessageManager.AppendCommand[0]);
    }

    @Test
    void doBackupWithoutMailboxShouldStoreEmptyBackup() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(destination);){
            zipAssert.containsOnlyEntriesMatching(new ZipAssert.EntryChecks[0]);
        }
    }

    @Test
    void doBackupWithoutMessageShouldStoreAnArchiveWithOnlyOneEntry() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.createMailbox(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX1);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(destination);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName("mailbox1/").isDirectory());
        }
    }

    @Test
    void doBackupMailboxWithAnnotationShouldStoreAnArchiveWithMailboxAndAnnotation() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.createMailbox(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX1);
        this.mailboxManager.updateAnnotations(MAILBOX_PATH_USER1_MAILBOX1, this.sessionUser, WITH_ANNOTATION_1);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(destination);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName("mailbox1/").isDirectory(), ZipAssert.EntryChecks.hasName("mailbox1/annotations/").isDirectory(), ZipAssert.EntryChecks.hasName("mailbox1/annotations/" + ANNOTATION_1_KEY.asString()).hasStringContent("annotation1 content"));
        }
    }

    @Test
    void doBackupWithOneMessageShouldStoreAnArchiveWithTwoEntries() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.createMailboxWithMessages(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX1, this.getMessage1AppendCommand());
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(destination);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName("mailbox1/").isDirectory(), ZipAssert.EntryChecks.hasName(MESSAGE_ID_1.serialize()).hasStringContent("Simple message content"));
        }
    }

    @Test
    void doBackupWithTwoMailboxesAndOneMessageShouldStoreAnArchiveWithThreeEntries() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.createMailboxWithMessages(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX1, this.getMessage1AppendCommand());
        this.createMailbox(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX2);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(destination);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName("mailbox1/").isDirectory(), ZipAssert.EntryChecks.hasName("mailbox2/").isDirectory(), ZipAssert.EntryChecks.hasName(MESSAGE_ID_1.serialize()).hasStringContent("Simple message content"));
        }
    }

    @Test
    void doBackupShouldOnlyArchiveTheMailboxOfTheUser() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.createMailboxWithMessages(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX1, this.getMessage1AppendCommand());
        this.createMailboxWithMessages(this.sessionOtherUser, MAILBOX_PATH_OTHER_USER_MAILBOX1, this.getMessage1OtherUserAppendCommand());
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip(destination);){
            zipAssert.containsOnlyEntriesMatching(ZipAssert.EntryChecks.hasName("mailbox1/").isDirectory(), ZipAssert.EntryChecks.hasName(MESSAGE_ID_1.serialize()).hasStringContent("Simple message content"));
        }
    }

    @Test
    void backupEmptyAccountThenRestoringItInUser2AccountShouldCreateNoElements() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        ByteArrayInputStream source = new ByteArrayInputStream(destination.toByteArray());
        MailboxBackup.BackupStatus backupStatus = (MailboxBackup.BackupStatus)Mono.from((Publisher)this.backup.restore(USERNAME_2, (InputStream)source)).block();
        Assertions.assertThat((Comparable)backupStatus).isEqualTo((Object)MailboxBackup.BackupStatus.DONE);
        List content = this.backup.getAccountContentForUser(this.sessionOtherUser);
        Assertions.assertThat((List)content).isEmpty();
    }

    @Test
    void backupAccountWithOneMailboxThenRestoringItInUser2AccountShouldCreateOneMailbox() throws Exception {
        this.createMailbox(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX1);
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        ByteArrayInputStream source = new ByteArrayInputStream(destination.toByteArray());
        MailboxBackup.BackupStatus backupStatus = (MailboxBackup.BackupStatus)Mono.from((Publisher)this.backup.restore(USERNAME_2, (InputStream)source)).block();
        Assertions.assertThat((Comparable)backupStatus).isEqualTo((Object)MailboxBackup.BackupStatus.DONE);
        List content = this.backup.getAccountContentForUser(this.sessionOtherUser);
        Assertions.assertThat((List)content).hasSize(1);
        DefaultMailboxBackup.MailAccountContent mailAccountContent = (DefaultMailboxBackup.MailAccountContent)content.get(0);
        Mailbox mailbox = mailAccountContent.getMailboxWithAnnotations().mailbox;
        Assertions.assertThat((String)mailbox.getName()).isEqualTo("mailbox1");
        Assertions.assertThat((long)mailAccountContent.getMessages().count()).isEqualTo(0L);
    }

    @Test
    void restoringAccountInNonEmptyAccountShouldNotBeDone() throws Exception {
        this.createMailbox(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX1);
        this.createMailbox(this.sessionOtherUser, MAILBOX_PATH_OTHER_USER_MAILBOX1);
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        ByteArrayInputStream source = new ByteArrayInputStream(destination.toByteArray());
        MailboxBackup.BackupStatus backupStatus = (MailboxBackup.BackupStatus)Mono.from((Publisher)this.backup.restore(USERNAME_2, (InputStream)source)).block();
        Assertions.assertThat((Comparable)backupStatus).isEqualTo((Object)MailboxBackup.BackupStatus.NON_EMPTY_RECEIVER_ACCOUNT);
    }

    @Test
    void backupAccountWithTwoMailboxesThenRestoringItInUser2AccountShouldCreateTwoMailboxes() throws Exception {
        this.createMailbox(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX1);
        this.createMailbox(this.sessionUser, MAILBOX_PATH_USER1_MAILBOX2);
        ByteArrayOutputStream destination = new ByteArrayOutputStream(4096);
        this.backup.backupAccount(USERNAME_1, (OutputStream)destination);
        ByteArrayInputStream source = new ByteArrayInputStream(destination.toByteArray());
        MailboxBackup.BackupStatus backupStatus = (MailboxBackup.BackupStatus)Mono.from((Publisher)this.backup.restore(USERNAME_2, (InputStream)source)).block();
        Assertions.assertThat((Comparable)backupStatus).isEqualTo((Object)MailboxBackup.BackupStatus.DONE);
        List content = this.backup.getAccountContentForUser(this.sessionOtherUser);
        Assertions.assertThat((List)content).hasSize(2);
        DefaultMailboxBackup.MailAccountContent contentMailbox1 = (DefaultMailboxBackup.MailAccountContent)content.get(0);
        Mailbox mailbox1 = contentMailbox1.getMailboxWithAnnotations().mailbox;
        Assertions.assertThat((String)mailbox1.getName()).isEqualTo("mailbox1");
        Assertions.assertThat((long)contentMailbox1.getMessages().count()).isEqualTo(0L);
        DefaultMailboxBackup.MailAccountContent contentMailbox2 = (DefaultMailboxBackup.MailAccountContent)content.get(1);
        Mailbox mailbox2 = contentMailbox2.getMailboxWithAnnotations().mailbox;
        Assertions.assertThat((String)mailbox2.getName()).isEqualTo("mailbox2");
        Assertions.assertThat((long)contentMailbox2.getMessages().count()).isEqualTo(0L);
    }

    private MessageManager.AppendCommand getMessage1AppendCommand() throws IOException {
        return MessageManager.AppendCommand.builder().withFlags(flags1).build((Content)ByteSourceContent.of((InputStream)MESSAGE_1.getFullContent()));
    }

    private MessageManager.AppendCommand getMessage1OtherUserAppendCommand() throws IOException {
        return MessageManager.AppendCommand.builder().withFlags(flags1).build((Content)ByteSourceContent.of((InputStream)MESSAGE_1_OTHER_USER.getFullContent()));
    }
}

