/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.test;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;

public class FakeMail
implements Mail {
    private static final String DEFAULT_REMOTE_HOST = "111.222.333.444";
    public static final String DEFAULT_REMOTE_ADDRESS = "127.0.0.1";
    private transient MimeMessage msg;
    private Collection<MailAddress> recipients;
    private String name;
    private MailAddress sender;
    private String state;
    private String errorMessage;
    private Date lastUpdated;
    private Map<AttributeName, Attribute> attributes;
    private long size;
    private String remoteAddr;
    private String remoteHost;
    private PerRecipientHeaders perRecipientHeaders;

    public static FakeMail fromMessage(MimeMessageBuilder message) throws MessagingException {
        return FakeMail.builder().name("from-message-builder").mimeMessage(message).build();
    }

    public static FakeMail fromMime(String text, String javaEncodingCharset, String javamailDefaultEncodingCharset) throws MessagingException, UnsupportedEncodingException {
        Properties javamailProperties = new Properties();
        javamailProperties.setProperty("mail.mime.charset", javamailDefaultEncodingCharset);
        return FakeMail.builder().name("from-mime-string").mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])text.getBytes(javaEncodingCharset))).build();
    }

    public static FakeMail from(MimeMessage message) throws MessagingException {
        return FakeMail.builder().name("from-message").mimeMessage(message).build();
    }

    public static FakeMail from(MimeMessageBuilder message) throws MessagingException {
        return FakeMail.from(message.build());
    }

    public static RequireName builder() {
        return x$0 -> new Builder(x$0);
    }

    public static FakeMail defaultFakeMail() throws MessagingException {
        return FakeMail.builder().name("default-id").build();
    }

    private static ImmutableMap<AttributeName, Attribute> toAttributeMap(Map<String, ?> attributes) {
        return (ImmutableMap)attributes.entrySet().stream().map(entry -> Attribute.convertToAttribute((String)((String)entry.getKey()), entry.getValue())).collect(ImmutableMap.toImmutableMap(Attribute::getName, Function.identity()));
    }

    private FakeMail(MimeMessage msg, List<MailAddress> recipients, String name, MailAddress sender, String state, String errorMessage, Date lastUpdated, Map<AttributeName, Attribute> attributes, long size, String remoteAddr, String remoteHost, PerRecipientHeaders perRecipientHeaders) {
        this.msg = msg;
        this.recipients = recipients;
        this.name = name;
        this.sender = sender;
        this.state = state;
        this.errorMessage = errorMessage;
        this.lastUpdated = lastUpdated;
        this.attributes = attributes;
        this.size = size;
        this.remoteAddr = remoteAddr;
        this.perRecipientHeaders = perRecipientHeaders;
        this.remoteHost = remoteHost;
    }

    public Mail duplicate() throws MessagingException {
        Builder builder = FakeMail.builder().name(this.name).recipients((List<MailAddress>)ImmutableList.copyOf(this.recipients)).sender(MaybeSender.of((MailAddress)this.sender)).state(Optional.ofNullable(this.state)).errorMessage(Optional.ofNullable(this.errorMessage)).lastUpdated(Optional.ofNullable(this.lastUpdated)).attributes(this.attributes.values()).size(this.size).remoteAddr(this.remoteAddr).remoteHost(this.remoteHost).addAllHeadersForRecipients(this.perRecipientHeaders);
        Optional.ofNullable(this.msg).ifPresent(builder::mimeMessage);
        return builder.build();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        Preconditions.checkNotNull((Object)newName);
        Preconditions.checkArgument((!newName.isEmpty() ? 1 : 0) != 0, (Object)"name must not be empty");
        this.name = newName;
    }

    public MimeMessage getMessage() throws MessagingException {
        return this.msg;
    }

    public Collection<MailAddress> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(Collection<MailAddress> recipients) {
        this.recipients = recipients;
    }

    public MailAddress getSender() {
        return this.sender;
    }

    public String getState() {
        return this.state;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public void setMessage(MimeMessage message) {
        this.msg = message;
        try {
            if (message != null && message.getSender() != null) {
                this.sender = new MailAddress((InternetAddress)message.getSender());
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException("Exception caught", e);
        }
    }

    public void setState(String state) {
        this.state = state;
    }

    public Stream<Attribute> attributes() {
        return this.attributes.values().stream();
    }

    public Serializable getAttribute(String name) {
        return this.toSerializable(this.attributes.get(AttributeName.of((String)name)));
    }

    public Optional<Attribute> getAttribute(AttributeName name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().stream().map(AttributeName::asString).iterator();
    }

    public Stream<AttributeName> attributeNames() {
        return this.attributes.keySet().stream();
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public Serializable removeAttribute(String name) {
        return this.toSerializable(this.attributes.remove(AttributeName.of((String)name)));
    }

    public Optional<Attribute> removeAttribute(AttributeName attributeName) {
        return Optional.ofNullable(this.attributes.remove(attributeName));
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    public Serializable setAttribute(String name, Serializable object) {
        Attribute attribute = Attribute.convertToAttribute((String)name, (Object)object);
        Attribute previous = this.attributes.put(attribute.getName(), attribute);
        return this.toSerializable(previous);
    }

    private Serializable toSerializable(Attribute previous) {
        return Optional.ofNullable(previous).map(Attribute::getValue).map(AttributeValue::getValue).orElse(null);
    }

    public Optional<Attribute> setAttribute(Attribute attribute) {
        return Optional.ofNullable(this.attributes.put(attribute.getName(), attribute));
    }

    public long getMessageSize() {
        return this.size;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setMessageSize(long size) {
        this.size = size;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Object obj = in.readObject();
            if (obj == null) {
                this.sender = null;
            } else if (obj instanceof String) {
                this.sender = new MailAddress((String)obj);
            } else if (obj instanceof MailAddress) {
                this.sender = (MailAddress)obj;
            }
        }
        catch (ParseException pe) {
            throw new IOException("Error parsing sender address: " + pe.getMessage());
        }
        this.recipients = (Collection)in.readObject();
        this.state = (String)in.readObject();
        this.errorMessage = (String)in.readObject();
        this.name = (String)in.readObject();
        this.remoteHost = (String)in.readObject();
        this.remoteAddr = (String)in.readObject();
        this.setLastUpdated((Date)in.readObject());
        try {
            this.setAttributesRaw((Map)in.readObject());
        }
        catch (OptionalDataException ode) {
            if (ode.eof) {
                this.attributes = new HashMap<AttributeName, Attribute>();
            }
            throw ode;
        }
        this.perRecipientHeaders = (PerRecipientHeaders)in.readObject();
    }

    public void setAttributesRaw(Map<String, Object> attr) {
        this.attributes = FakeMail.toAttributeMap(attr);
    }

    public Map<String, Object> getAttributesRaw() {
        return (Map)this.attributes.entrySet().stream().collect(ImmutableMap.toImmutableMap(a -> ((AttributeName)a.getKey()).asString(), b -> ((Attribute)b.getValue()).getValue().value()));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.sender);
        out.writeObject(this.recipients);
        out.writeObject(this.state);
        out.writeObject(this.errorMessage);
        out.writeObject(this.name);
        out.writeObject(this.remoteHost);
        out.writeObject(this.remoteAddr);
        out.writeObject(this.lastUpdated);
        out.writeObject(this.getAttributesRaw());
        out.writeObject(this.perRecipientHeaders);
    }

    public final boolean equals(Object o) {
        if (o instanceof FakeMail) {
            FakeMail that = (FakeMail)o;
            return Objects.equal((Object)this.size, (Object)that.size) && Objects.equal(this.recipients, that.recipients) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.sender, (Object)that.sender) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.errorMessage, (Object)that.errorMessage) && Objects.equal((Object)this.lastUpdated, (Object)that.lastUpdated) && Objects.equal(this.attributes, that.attributes) && Objects.equal((Object)this.remoteHost, (Object)that.remoteHost) && Objects.equal((Object)this.perRecipientHeaders, (Object)that.perRecipientHeaders) && Objects.equal((Object)this.remoteAddr, (Object)that.remoteAddr);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.sender, this.recipients, this.state, this.errorMessage, this.lastUpdated, this.attributes, this.size, this.remoteAddr, this.remoteHost, this.perRecipientHeaders});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("msg", (Object)this.msg).add("recipients", this.recipients).add("name", (Object)this.name).add("sender", (Object)this.sender).add("state", (Object)this.state).add("errorMessage", (Object)this.errorMessage).add("lastUpdated", (Object)this.lastUpdated).add("attributes", this.attributes).add("size", this.size).add("remoteAddr", (Object)this.remoteAddr).toString();
    }

    public PerRecipientHeaders getPerRecipientSpecificHeaders() {
        return this.perRecipientHeaders;
    }

    public void addSpecificHeaderForRecipient(PerRecipientHeaders.Header header, MailAddress recipient) {
        this.perRecipientHeaders.addHeaderForRecipient(header, recipient);
    }

    public static interface RequireName {
        public Builder name(String var1);
    }

    public static class Builder {
        private final String name;
        private Optional<String> fileName;
        private Optional<MimeMessage> mimeMessage;
        private List<MailAddress> recipients;
        private Optional<MailAddress> sender;
        private Optional<String> state;
        private Optional<String> errorMessage;
        private Optional<Date> lastUpdated;
        private Map<AttributeName, Attribute> attributes;
        private Optional<Long> size;
        private Optional<String> remoteAddr;
        private Optional<String> remoteHost;
        private PerRecipientHeaders perRecipientHeaders;

        private Builder(String name) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name must not be empty");
            this.name = name;
            this.fileName = Optional.empty();
            this.mimeMessage = Optional.empty();
            this.recipients = Lists.newArrayList();
            this.sender = Optional.empty();
            this.state = Optional.empty();
            this.errorMessage = Optional.empty();
            this.lastUpdated = Optional.empty();
            this.attributes = Maps.newHashMap();
            this.size = Optional.empty();
            this.remoteAddr = Optional.empty();
            this.remoteHost = Optional.empty();
            this.perRecipientHeaders = new PerRecipientHeaders();
        }

        public Builder attribute(Attribute attribute) {
            this.attributes.put(attribute.getName(), attribute);
            return this;
        }

        public Builder size(long size) {
            this.size = Optional.of(size);
            return this;
        }

        public Builder fileName(String fileName) {
            Preconditions.checkNotNull((Object)fileName, (Object)"'fileName' can not be null");
            this.fileName = Optional.of(fileName);
            return this;
        }

        public Builder mimeMessage(MimeMessage mimeMessage) {
            Preconditions.checkNotNull((Object)mimeMessage, (Object)"'mimeMessage' can not be null");
            this.mimeMessage = Optional.of(mimeMessage);
            return this;
        }

        public Builder mimeMessage(MimeMessageBuilder mimeMessage) throws MessagingException {
            Preconditions.checkNotNull((Object)mimeMessage, (Object)"'mimeMessage' can not be null");
            this.mimeMessage = Optional.of(mimeMessage.build());
            return this;
        }

        public Builder recipients() {
            return this;
        }

        public Builder recipients(List<MailAddress> recipients) {
            this.recipients.addAll(recipients);
            return this;
        }

        public Builder recipients(MailAddress ... recipients) {
            return this.recipients((List<MailAddress>)ImmutableList.copyOf((Object[])recipients));
        }

        public Builder recipients(String ... recipients) {
            Preconditions.checkNotNull((Object)recipients, (Object)"'recipients' can not be null");
            return this.recipients((List)Arrays.stream(recipients).map(Throwing.function(MailAddress::new)).collect(ImmutableList.toImmutableList()));
        }

        public Builder recipient(MailAddress recipient) {
            return this.recipients(recipient);
        }

        public Builder recipient(String recipient) throws AddressException {
            return this.recipients(recipient);
        }

        public Builder sender(MailAddress sender) {
            Preconditions.checkNotNull((Object)sender, (Object)"'sender' can not be null");
            this.sender(MaybeSender.of((MailAddress)sender));
            return this;
        }

        public Builder sender(MaybeSender sender) {
            this.sender = sender.asOptional();
            return this;
        }

        public Builder sender(String sender) throws AddressException {
            return this.sender(new MailAddress(sender));
        }

        public Builder state(String state) {
            Preconditions.checkNotNull((Object)state, (Object)"'state' can not be null");
            this.state(Optional.of(state));
            return this;
        }

        public Builder state(Optional<String> state) {
            this.state = state;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            Preconditions.checkNotNull((Object)errorMessage, (Object)"'errorMessage' can not be null");
            this.errorMessage(Optional.of(errorMessage));
            return this;
        }

        public Builder errorMessage(Optional<String> errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder lastUpdated(Date lastUpdated) {
            Preconditions.checkNotNull((Object)lastUpdated, (Object)"'lastUpdated' can not be null");
            this.lastUpdated(Optional.of(lastUpdated));
            return this;
        }

        public Builder lastUpdated(Optional<Date> lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        @Deprecated
        public Builder attribute(String name, Serializable object) {
            Attribute attribute = Attribute.convertToAttribute((String)name, (Object)object);
            this.attributes.put(attribute.getName(), attribute);
            return this;
        }

        @Deprecated
        public Builder attributes(Map<String, Serializable> attributes) {
            this.attributes.putAll((Map)attributes.entrySet().stream().map(entry -> Attribute.convertToAttribute((String)((String)entry.getKey()), entry.getValue())).collect(ImmutableMap.toImmutableMap(Attribute::getName, Function.identity())));
            return this;
        }

        public Builder attributes(Collection<Attribute> attributes) {
            this.attributes.putAll((Map)attributes.stream().collect(ImmutableMap.toImmutableMap(Attribute::getName, Function.identity())));
            return this;
        }

        public Builder remoteAddr(String remoteAddr) {
            this.remoteAddr = Optional.of(remoteAddr);
            return this;
        }

        public Builder remoteHost(String remoteHost) {
            this.remoteHost = Optional.of(remoteHost);
            return this;
        }

        public Builder addHeaderForRecipient(PerRecipientHeaders.Header header, MailAddress recipient) {
            this.perRecipientHeaders.addHeaderForRecipient(header, recipient);
            return this;
        }

        public Builder addAllHeadersForRecipients(PerRecipientHeaders perRecipientHeaders) {
            this.perRecipientHeaders.addAll(perRecipientHeaders);
            return this;
        }

        public FakeMail build() throws MessagingException {
            return new FakeMail(this.getMimeMessage(), this.recipients, this.name, this.sender.orElse(null), this.state.orElse(null), this.errorMessage.orElse(null), this.lastUpdated.orElse(null), this.attributes, this.size.orElse(0L), this.remoteAddr.orElse(FakeMail.DEFAULT_REMOTE_ADDRESS), this.remoteHost.orElse(FakeMail.DEFAULT_REMOTE_HOST), this.perRecipientHeaders);
        }

        private MimeMessage getMimeMessage() throws MessagingException {
            Preconditions.checkState((!this.fileName.isPresent() || !this.mimeMessage.isPresent() ? 1 : 0) != 0, (Object)"You can not specify a MimeMessage object when you alredy set Content from a file");
            if (this.fileName.isPresent()) {
                return MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream(this.fileName.get()));
            }
            return this.mimeMessage.orElse(null);
        }
    }
}

