/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.smtp;

import java.util.Locale;
import org.apache.james.mpt.api.HostSystem;
import org.apache.james.mpt.script.SimpleScriptedTestProtocol;
import org.apache.james.mpt.smtp.SmtpHostSystem;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class SmtpAuthCommandTest {
    public static final String USER = "bob";
    public static final String DOMAIN = "mydomain.tld";
    public static final String USER_AT_DOMAIN = "bob@mydomain.tld";
    public static final String PASSWORD = "secret";
    private SmtpHostSystem hostSystem;
    private SimpleScriptedTestProtocol scriptedTest;

    protected abstract SmtpHostSystem createSmtpHostSystem();

    @BeforeEach
    public void setUp() throws Exception {
        this.hostSystem = this.createSmtpHostSystem();
        String scriptDir = "/org/apache/james/smtp/scripts/";
        this.scriptedTest = (SimpleScriptedTestProtocol)((SimpleScriptedTestProtocol)new SimpleScriptedTestProtocol(scriptDir, (HostSystem)this.hostSystem).withLocale(Locale.US)).withUser(USER_AT_DOMAIN, PASSWORD);
    }

    @Test
    public void bobShouldBeAbleToAuthPlain() throws Exception {
        this.scriptedTest.run("authplain");
    }
}

