/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.smtp;

import io.restassured.response.ValidatableResponse;
import java.time.Duration;
import java.util.Locale;
import org.apache.james.dnsservice.api.InMemoryDNSService;
import org.apache.james.mpt.api.HostSystem;
import org.apache.james.mpt.script.SimpleScriptedTestProtocol;
import org.apache.james.mpt.smtp.SmtpHostSystem;
import org.apache.james.utils.FakeSmtp;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public interface ForwardSmtpTest {
    public static final String USER = "bob";
    public static final String DOMAIN = "mydomain.tld";
    public static final String USER_AT_DOMAIN = "bob@mydomain.tld";
    public static final String PASSWORD = "secret";
    public static final Duration slowPacedPollInterval = Durations.ONE_HUNDRED_MILLISECONDS;
    public static final ConditionFactory calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).await();
    @RegisterExtension
    public static final FakeSmtp fakeSmtp = FakeSmtp.withDefaultPort();

    @Test
    default public void forwardingAnEmailShouldWork(SmtpHostSystem hostSystem, InMemoryDNSService dnsService) throws Exception {
        SimpleScriptedTestProtocol scriptedTest = (SimpleScriptedTestProtocol)((SimpleScriptedTestProtocol)new SimpleScriptedTestProtocol("/org/apache/james/smtp/scripts/", (HostSystem)hostSystem).withLocale(Locale.US)).withUser(USER_AT_DOMAIN, PASSWORD);
        dnsService.registerMxRecord("yopmail.com", fakeSmtp.getContainer().getContainerIp());
        hostSystem.addAddressMapping(USER, DOMAIN, "ray@yopmail.com");
        scriptedTest.run("helo");
        calmlyAwait.atMost(Durations.TWO_MINUTES).untilAsserted(() -> fakeSmtp.assertEmailReceived(response -> ((ValidatableResponse)((ValidatableResponse)response.body("[0].from", Matchers.equalTo((Object)"matthieu@yopmail.com"), new Object[0])).body("[0].subject", Matchers.equalTo((Object)"test"), new Object[0])).body("[0].text", Matchers.equalTo((Object)"content"), new Object[0])));
    }
}

