/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.smtp;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JamesServerExtension;
import org.apache.james.RegistrableExtension;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.mpt.api.Continuation;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.Session;
import org.apache.james.mpt.monitor.SystemLoggingMonitor;
import org.apache.james.mpt.session.ExternalSessionFactory;
import org.apache.james.mpt.smtp.SmtpHostSystem;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class SmtpTestExtension
implements RegistrableExtension {
    private final SmtpGuiceProbe.SmtpServerConnectedType smtpServerConnectedType;
    private final JamesServerExtension testExtension;
    private SmtpHostSystem smtpHostSystem;

    public SmtpTestExtension(SmtpGuiceProbe.SmtpServerConnectedType smtpServerConnectedType, JamesServerExtension testExtension) {
        this.smtpServerConnectedType = smtpServerConnectedType;
        this.testExtension = testExtension;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.smtpHostSystem = new HostSystem(this.testExtension.getGuiceJamesServer(), this.smtpServerConnectedType);
    }

    public void afterEach(ExtensionContext context) throws Exception {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().isAssignableFrom(SmtpHostSystem.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.smtpHostSystem;
    }

    public static class HostSystem
    implements SmtpHostSystem {
        private final ExternalSessionFactory sessionFactory;
        private final SmtpGuiceProbe.SmtpServerConnectedType smtpServerConnectedType;
        private final GuiceJamesServer jamesServer;

        public HostSystem(GuiceJamesServer jamesServer, SmtpGuiceProbe.SmtpServerConnectedType smtpServerConnectedType) {
            this.jamesServer = jamesServer;
            this.smtpServerConnectedType = smtpServerConnectedType;
            SmtpGuiceProbe smtpProbe = (SmtpGuiceProbe)jamesServer.getProbe(SmtpGuiceProbe.class);
            Port smtpPort = (Port)this.smtpServerConnectedType.getPortExtractor().apply(smtpProbe);
            this.sessionFactory = new ExternalSessionFactory("localhost", smtpPort, (Monitor)new SystemLoggingMonitor(), "220 mydomain.tld smtp");
        }

        public boolean addUser(Username userAtDomain, String password) throws Exception {
            Optional domain = userAtDomain.getDomainPart();
            Preconditions.checkArgument((boolean)domain.isPresent(), (Object)"The 'user' should contain the 'domain'");
            this.createDomainIfNeeded(((Domain)domain.get()).asString());
            ((DataProbeImpl)this.jamesServer.getProbe(DataProbeImpl.class)).addUser(userAtDomain.asString(), password);
            return true;
        }

        public Session newSession(Continuation continuation) throws Exception {
            return this.sessionFactory.newSession(continuation);
        }

        private void createDomainIfNeeded(String domain) throws Exception {
            if (!((DataProbeImpl)this.jamesServer.getProbe(DataProbeImpl.class)).containsDomain(domain)) {
                ((DataProbeImpl)this.jamesServer.getProbe(DataProbeImpl.class)).addDomain(domain);
            }
        }

        @Override
        public void addAddressMapping(String user, String domain, String address) throws Exception {
            ((DataProbeImpl)this.jamesServer.getProbe(DataProbeImpl.class)).addAddressMapping(user, domain, address);
        }

        public void beforeTest() throws Exception {
        }

        public void afterTest() throws Exception {
        }
    }
}

