/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.smtp;

import java.util.Locale;
import org.apache.james.mpt.api.HostSystem;
import org.apache.james.mpt.script.SimpleScriptedTestProtocol;
import org.apache.james.mpt.smtp.SmtpHostSystem;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class SmtpStarttlsCommandTest {
    public static final String USER = "bob";
    public static final String DOMAIN = "mydomain.tld";
    public static final String USER_AT_DOMAIN = "bob@mydomain.tld";
    public static final String PASSWORD = "secret";
    protected SmtpHostSystem hostSystem;
    private SimpleScriptedTestProtocol scriptedTest;

    @BeforeEach
    void setUp(SmtpHostSystem hostSystem) throws Exception {
        this.hostSystem = hostSystem;
        String scriptDir = "/org/apache/james/smtp/scripts/";
        this.scriptedTest = (SimpleScriptedTestProtocol)((SimpleScriptedTestProtocol)new SimpleScriptedTestProtocol(scriptDir, (HostSystem)hostSystem).withLocale(Locale.US)).withUser(USER_AT_DOMAIN, PASSWORD);
    }

    @Test
    void starttlsShouldWork() throws Exception {
        this.scriptedTest.run("starttls");
    }

    @Test
    void startTlsShouldBeRejectedWhenAlreadyAuthenticated() throws Exception {
        this.scriptedTest.run("starttls_session_fixation");
    }

    @Test
    void starttlsShouldBeRejectedWhenFollowedByCommand() throws Exception {
        this.scriptedTest.run("starttls_with_injection");
    }

    @Test
    void shouldNotRejectContentWithStartTls() throws Exception {
        this.scriptedTest.run("data_with_starttls");
    }

    @Test
    void shouldNotRejectRcptWithStartTls() throws Exception {
        this.scriptedTest.withUser("starttls@mydomain.tld", PASSWORD);
        this.scriptedTest.run("rcpt_with_starttls");
    }

    @Test
    void shouldNotRejectContentStartsWithStartTls() throws Exception {
        this.scriptedTest.run("data_starts_with_starttls");
    }
}

