/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.cyrus.host;

import com.google.inject.Inject;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mpt.imapmailbox.MailboxMessageAppender;
import org.apache.james.mpt.imapmailbox.cyrus.host.CyrusHostSystem;
import org.apache.james.mpt.protocol.ProtocolSession;

public class MailboxMessageAppenderOnCyrusHost
implements MailboxMessageAppender {
    private static final String LOCATION = "cyrus.MailboxMessageProviderOnCyrusHost";
    private final CyrusHostSystem hostSystem;

    @Inject
    private MailboxMessageAppenderOnCyrusHost(CyrusHostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    public void fillMailbox(MailboxPath mailboxPath) {
        String mailboxName = this.hostSystem.createMailboxStringFromMailboxPath(mailboxPath);
        ProtocolSession protocolSession = this.hostSystem.logAndGetAdminProtocolSession(new ProtocolSession());
        protocolSession.cl(String.format("a001 SETACL %s %s %s", mailboxName, "cyrus", "lrswipkxtecda"));
        protocolSession.sl("a001 OK .*", LOCATION);
        this.appendMessage(protocolSession, "a002", mailboxName, "");
        this.appendMessage(protocolSession, "a003", mailboxName, "\\Seen");
        this.appendMessage(protocolSession, "a004", mailboxName, "\\Flagged");
        this.appendMessage(protocolSession, "a005", mailboxName, "\\Deleted");
        this.hostSystem.executeProtocolSession(this.hostSystem.logoutAndGetProtocolSession(protocolSession));
    }

    private void appendMessage(ProtocolSession protocolSession, String commandId, String mailbox, String flagString) {
        protocolSession.cl(String.format("%s APPEND %s (%s) {310}", commandId, mailbox, flagString));
        protocolSession.sl("\\+ go ahead", LOCATION);
        protocolSession.cl("Date: Mon, 7 Feb 1994 21:52:25 -0800 (PST)");
        protocolSession.cl("From: Fred Foobar <foobar@Blurdybloop.COM>");
        protocolSession.cl("Subject: afternoon meeting 2");
        protocolSession.cl("To: mooch@owatagu.siam.edu");
        protocolSession.cl("Message-Id: <B27397-0100000@Blurdybloop.COM>");
        protocolSession.cl("MIME-Version: 1.0");
        protocolSession.cl("Content-Type: TEXT/PLAIN; CHARSET=US-ASCII");
        protocolSession.cl("");
        protocolSession.cl("Hello Joe, could we change that to 4:00pm tomorrow?");
        protocolSession.cl("");
        protocolSession.sl(String.format("%s OK.*", commandId), LOCATION);
    }
}

