/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.cyrus.host;

import com.google.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mpt.imapmailbox.GrantRightsOnHost;
import org.apache.james.mpt.imapmailbox.cyrus.host.CyrusHostSystem;
import org.apache.james.mpt.protocol.ProtocolSession;

public class GrantRightsOnCyrusHost
implements GrantRightsOnHost {
    private static final String GRANT_RIGHTS_LOCATION = "ACLCommands.grantRights";
    private final CyrusHostSystem system;

    @Inject
    private GrantRightsOnCyrusHost(CyrusHostSystem system) {
        this.system = system;
    }

    public void grantRights(MailboxPath mailboxPath, Username username, MailboxACL.Rfc4314Rights rights) throws Exception {
        ProtocolSession protocolSession = this.system.logAndGetAdminProtocolSession(new ProtocolSession());
        protocolSession.cl(String.format("A1 SETACL %s %s %s", this.system.createMailboxStringFromMailboxPath(mailboxPath), username.asString(), rights.serialize()));
        protocolSession.sl("A1 OK .*", GRANT_RIGHTS_LOCATION);
        this.system.executeProtocolSession(this.system.logoutAndGetProtocolSession(protocolSession));
    }
}

