/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.cyrus.host;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ExecCreation;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;

public class Docker {
    private static final int IMAP_PORT = 143;
    private static final String EXPOSED_IMAP_PORT = "143/tcp";
    private static final HostConfig ALL_PORTS_HOST_CONFIG = HostConfig.builder().publishAllPorts(Boolean.valueOf(true)).build();
    private final DefaultDockerClient dockerClient;
    private final ContainerConfig containerConfig;

    public Docker(String imageName) {
        this.containerConfig = ContainerConfig.builder().image(imageName).networkDisabled(Boolean.valueOf(false)).exposedPorts((Set)ImmutableSet.of((Object)EXPOSED_IMAP_PORT)).hostConfig(ALL_PORTS_HOST_CONFIG).build();
        try {
            this.dockerClient = DefaultDockerClient.fromEnv().build();
            this.dockerClient.pull(imageName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ContainerCreation start() throws Exception {
        ContainerCreation container = this.dockerClient.createContainer(this.containerConfig);
        this.dockerClient.startContainer(container.id());
        this.waitingForSocketToBeReady(container);
        return container;
    }

    private void waitingForSocketToBeReady(ContainerCreation container) {
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).with().pollInterval(10L, TimeUnit.MILLISECONDS).and().ignoreExceptions().until(() -> this.socketIsReady(container));
    }

    private boolean socketIsReady(ContainerCreation container) throws UnknownHostException, IOException {
        try (Socket socket = new Socket(this.getHost(container), this.getIMAPPort(container));){
            boolean bl = socket.getInputStream().read() >= 0;
            return bl;
        }
    }

    public void stop(ContainerCreation container) {
        try {
            this.dockerClient.killContainer(container.id());
            this.dockerClient.removeContainer(container.id(), new DockerClient.RemoveContainerParam[]{DockerClient.RemoveContainerParam.removeVolumes()});
        }
        catch (DockerException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getHost(ContainerCreation container) {
        return this.dockerClient.getHost();
    }

    public int getIMAPPort(ContainerCreation container) {
        try {
            return Integer.parseInt(((PortBinding)Iterables.getOnlyElement((Iterable)((Iterable)this.dockerClient.inspectContainer(container.id()).networkSettings().ports().get((Object)EXPOSED_IMAP_PORT)))).hostPort());
        }
        catch (DockerException | InterruptedException | NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public void createUser(ContainerCreation container, String user, String password) throws DockerException, InterruptedException {
        String createUserCommand = String.format("echo %s | saslpasswd2 -u test -c %s -p", password, user);
        ExecCreation execCreation = this.dockerClient.execCreate(container.id(), new String[]{"/bin/bash", "-c", createUserCommand}, new DockerClient.ExecCreateParam[0]);
        this.dockerClient.execStart(execCreation.id(), new DockerClient.ExecStartParameter[0]);
    }
}

