/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.cyrus.host;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.spotify.docker.client.messages.ContainerCreation;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.Session;
import org.apache.james.mpt.api.UserAdder;
import org.apache.james.mpt.host.ExternalHostSystem;
import org.apache.james.mpt.imapmailbox.cyrus.host.Docker;
import org.apache.james.mpt.monitor.NullMonitor;
import org.apache.james.mpt.protocol.ProtocolSession;

@Singleton
public class CyrusHostSystem
extends ExternalHostSystem
implements Provider<ContainerCreation> {
    private static final String CREATE_MAILBOX_LOCATION = "CyrusHostSystem.createMailbox";
    private static final String SHABANG = "* OK IMAP4rev1 Server ready";
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT});
    private final Docker docker;
    private Supplier<InetSocketAddress> addressSupplier;
    private ContainerCreation container;

    @Inject
    private CyrusHostSystem(Docker docker, UserAdder userAdder) {
        super(SUPPORTED_FEATURES, (Monitor)new NullMonitor(), SHABANG, userAdder);
        this.docker = docker;
    }

    protected InetSocketAddress getAddress() {
        return this.addressSupplier.get();
    }

    public boolean addUser(Username user, String password) throws Exception {
        return super.addUser(user, password) && this.createUserInbox(user);
    }

    private boolean createUserInbox(Username username) {
        this.createMailbox(MailboxPath.forUser((Username)username, (String)""));
        return true;
    }

    public void beforeTest() throws Exception {
        this.container = this.docker.start();
        this.addressSupplier = () -> new InetSocketAddress(this.docker.getHost(this.container), this.docker.getIMAPPort(this.container));
    }

    public void afterTest() throws Exception {
        this.docker.stop(this.container);
        this.container = null;
        this.addressSupplier = null;
    }

    public ContainerCreation get() {
        return this.container;
    }

    public void createMailbox(MailboxPath mailboxPath) {
        ProtocolSession protocolSession = this.logAndGetAdminProtocolSession(new ProtocolSession());
        protocolSession.cl(String.format("A1 CREATE %s", this.createMailboxStringFromMailboxPath(mailboxPath)));
        protocolSession.sl("A1 OK .*", CREATE_MAILBOX_LOCATION);
        this.executeProtocolSession(this.logoutAndGetProtocolSession(protocolSession));
    }

    public ProtocolSession logoutAndGetProtocolSession(ProtocolSession protocolSession) {
        protocolSession.cl("A2 LOGOUT");
        protocolSession.sl("\\* BYE .*", CREATE_MAILBOX_LOCATION);
        return protocolSession;
    }

    public ProtocolSession logAndGetAdminProtocolSession(ProtocolSession protocolSession) {
        protocolSession.sl(".*", CREATE_MAILBOX_LOCATION);
        protocolSession.cl(". LOGIN cyrus cyrus");
        protocolSession.sl("\\. OK .*", CREATE_MAILBOX_LOCATION);
        return protocolSession;
    }

    public String createMailboxStringFromMailboxPath(MailboxPath mailboxPath) {
        return Joiner.on((char)'.').skipNulls().join((Object)"user", (Object)mailboxPath.getUser(), new Object[]{Strings.emptyToNull((String)mailboxPath.getName())});
    }

    public void executeProtocolSession(ProtocolSession protocolSession) {
        try {
            Session session = this.newSession(null);
            try {
                session.start();
                protocolSession.runSessions(new Session[]{session});
            }
            finally {
                session.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setQuotaLimits(QuotaCountLimit maxMessageQuota, QuotaSizeLimit maxStorageQuota) throws Exception {
        throw new NotImplementedException("not implemented");
    }
}

