/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.cyrus;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.james.mpt.api.ImapHostSystem;
import org.apache.james.mpt.imapmailbox.GrantRightsOnHost;
import org.apache.james.mpt.imapmailbox.MailboxMessageAppender;
import org.apache.james.mpt.imapmailbox.cyrus.CyrusMailboxTestModule;
import org.apache.james.mpt.imapmailbox.suite.ACLIntegration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class CyrusACLIntegration
extends ACLIntegration {
    private ImapHostSystem system;
    private GrantRightsOnHost grantRightsOnHost;
    private MailboxMessageAppender mailboxMessageAppender;

    @BeforeEach
    public void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new CyrusMailboxTestModule()});
        this.system = (ImapHostSystem)injector.getInstance(ImapHostSystem.class);
        this.grantRightsOnHost = (GrantRightsOnHost)injector.getInstance(GrantRightsOnHost.class);
        this.mailboxMessageAppender = (MailboxMessageAppender)injector.getInstance(MailboxMessageAppender.class);
        this.system.beforeTest();
        super.setUp();
    }

    protected ImapHostSystem createImapHostSystem() {
        return this.system;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.system.afterTest();
    }

    protected GrantRightsOnHost createGrantRightsOnHost() {
        return this.grantRightsOnHost;
    }

    protected MailboxMessageAppender createMailboxMessageAppender() {
        return this.mailboxMessageAppender;
    }
}

