/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.cassandra.host;

import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.mailbox.cassandra.mail.MailboxAggregateModule;
import org.apache.james.mpt.host.JamesImapHostSystem;
import org.apache.james.mpt.imapmailbox.cassandra.host.CassandraHostSystem;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CassandraHostSystemExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private final CassandraClusterExtension cassandraExtension = new CassandraClusterExtension(MailboxAggregateModule.MODULE_WITH_QUOTA);
    private CassandraHostSystem system;

    public void afterAll(ExtensionContext extensionContext) {
        this.cassandraExtension.afterAll(extensionContext);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.system.afterTest();
        this.cassandraExtension.afterEach(extensionContext);
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.cassandraExtension.beforeAll(extensionContext);
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.cassandraExtension.beforeEach(extensionContext);
        this.system = new CassandraHostSystem(this.cassandraExtension.getCassandraCluster());
        this.system.beforeTest();
    }

    public JamesImapHostSystem getImapHostSystem() {
        return this.system;
    }
}

