/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.cassandra.host;

import com.datastax.oss.driver.api.core.CqlSession;
import java.time.Clock;
import java.time.Instant;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.TestingSession;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.InVMEventBus;
import org.apache.james.events.MemoryEventDeadLetters;
import org.apache.james.events.delivery.EventDelivery;
import org.apache.james.events.delivery.InVmEventDelivery;
import org.apache.james.imap.encode.main.DefaultImapEncoderFactory;
import org.apache.james.imap.main.DefaultImapDecoderFactory;
import org.apache.james.imap.processor.main.DefaultImapProcessorFactory;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.cassandra.CassandraMailboxManager;
import org.apache.james.mailbox.cassandra.CassandraMailboxSessionMapperFactory;
import org.apache.james.mailbox.cassandra.TestCassandraMailboxSessionMapperFactory;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.quota.CassandraCurrentQuotaManager;
import org.apache.james.mailbox.cassandra.quota.CassandraGlobalMaxQuotaDao;
import org.apache.james.mailbox.cassandra.quota.CassandraPerDomainMaxQuotaDao;
import org.apache.james.mailbox.cassandra.quota.CassandraPerUserMaxQuotaDao;
import org.apache.james.mailbox.cassandra.quota.CassandraPerUserMaxQuotaManager;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.SessionProviderImpl;
import org.apache.james.mailbox.store.StoreAttachmentManager;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMessageIdManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.NaiveThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.ListeningCurrentQuotaUpdater;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.quota.StoreQuotaManager;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SimpleMessageSearchIndex;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.logger.DefaultMetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.host.JamesImapHostSystem;
import org.apache.james.utils.UpdatableTickingClock;

public class CassandraHostSystem
extends JamesImapHostSystem {
    private static final ImapFeatures IMAP_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT, ImapFeatures.Feature.MOVE_SUPPORT, ImapFeatures.Feature.USER_FLAGS_SUPPORT, ImapFeatures.Feature.QUOTA_SUPPORT, ImapFeatures.Feature.ANNOTATION_SUPPORT, ImapFeatures.Feature.MOD_SEQ_SEARCH});
    private final CassandraCluster cassandra;
    private CassandraMailboxManager mailboxManager;
    private CassandraPerUserMaxQuotaManager perUserMaxQuotaManager;

    public CassandraHostSystem(CassandraCluster cluster) {
        this.cassandra = cluster;
    }

    public CassandraCluster getCassandra() {
        return this.cassandra;
    }

    public void beforeTest() throws Exception {
        super.beforeTest();
        TestingSession session = this.cassandra.getConf();
        CassandraMessageId.Factory messageIdFactory = new CassandraMessageId.Factory();
        NaiveThreadIdGuessingAlgorithm threadIdGuessingAlgorithm = new NaiveThreadIdGuessingAlgorithm();
        UpdatableTickingClock clock = new UpdatableTickingClock(Instant.now());
        CassandraMailboxSessionMapperFactory mapperFactory = TestCassandraMailboxSessionMapperFactory.forTests((CassandraCluster)this.cassandra, (CassandraMessageId.Factory)messageIdFactory);
        InVMEventBus eventBus = new InVMEventBus((EventDelivery)new InVmEventDelivery((MetricFactory)new RecordingMetricFactory()), EventBusTestFixture.RETRY_BACKOFF_CONFIGURATION, (EventDeadLetters)new MemoryEventDeadLetters());
        StoreRightManager storeRightManager = new StoreRightManager((MailboxSessionMapperFactory)mapperFactory, (MailboxACLResolver)new UnionMailboxACLResolver(), (EventBus)eventBus);
        StoreMailboxAnnotationManager annotationManager = new StoreMailboxAnnotationManager((MailboxSessionMapperFactory)mapperFactory, storeRightManager);
        SessionProviderImpl sessionProvider = new SessionProviderImpl(this.authenticator, this.authorizator);
        DefaultUserQuotaRootResolver quotaRootResolver = new DefaultUserQuotaRootResolver((SessionProvider)sessionProvider, (MailboxSessionMapperFactory)mapperFactory);
        this.perUserMaxQuotaManager = new CassandraPerUserMaxQuotaManager(new CassandraPerUserMaxQuotaDao((CqlSession)session), new CassandraPerDomainMaxQuotaDao((CqlSession)this.cassandra.getConf()), new CassandraGlobalMaxQuotaDao((CqlSession)session));
        CassandraCurrentQuotaManager currentQuotaManager = new CassandraCurrentQuotaManager((CqlSession)session);
        StoreQuotaManager quotaManager = new StoreQuotaManager((CurrentQuotaManager)currentQuotaManager, (MaxQuotaManager)this.perUserMaxQuotaManager);
        ListeningCurrentQuotaUpdater quotaUpdater = new ListeningCurrentQuotaUpdater((CurrentQuotaManager)currentQuotaManager, (QuotaRootResolver)quotaRootResolver, (EventBus)eventBus, (QuotaManager)quotaManager);
        QuotaComponents quotaComponents = new QuotaComponents((MaxQuotaManager)this.perUserMaxQuotaManager, (QuotaManager)quotaManager, (QuotaRootResolver)quotaRootResolver);
        StoreMessageIdManager messageIdManager = new StoreMessageIdManager((RightManager)storeRightManager, (MailboxSessionMapperFactory)mapperFactory, (EventBus)eventBus, (QuotaManager)quotaManager, (QuotaRootResolver)quotaRootResolver, PreDeletionHooks.NO_PRE_DELETION_HOOK);
        StoreAttachmentManager attachmentManager = new StoreAttachmentManager((AttachmentMapperFactory)mapperFactory, (MessageIdManager)messageIdManager);
        SimpleMessageSearchIndex index = new SimpleMessageSearchIndex((MessageMapperFactory)mapperFactory, (MailboxMapperFactory)mapperFactory, (TextExtractor)new DefaultTextExtractor(), (AttachmentContentLoader)attachmentManager);
        this.mailboxManager = new CassandraMailboxManager(mapperFactory, (SessionProvider)sessionProvider, (MailboxPathLocker)new JVMMailboxPathLocker(), new MessageParser(), (MessageId.Factory)messageIdFactory, (EventBus)eventBus, annotationManager, storeRightManager, quotaComponents, (MessageSearchIndex)index, MailboxManagerConfiguration.DEFAULT, PreDeletionHooks.NO_PRE_DELETION_HOOK, (ThreadIdGuessingAlgorithm)threadIdGuessingAlgorithm, (Clock)clock);
        eventBus.register((EventListener.ReactiveGroupEventListener)quotaUpdater);
        StoreSubscriptionManager subscriptionManager = new StoreSubscriptionManager((SubscriptionMapperFactory)mapperFactory, (MailboxSessionMapperFactory)mapperFactory, (EventBus)eventBus);
        this.configure(new DefaultImapDecoderFactory().buildImapDecoder(), new DefaultImapEncoderFactory().buildImapEncoder(), DefaultImapProcessorFactory.createDefaultProcessor((MailboxManager)this.mailboxManager, (EventBus)eventBus, (SubscriptionManager)subscriptionManager, (QuotaManager)quotaManager, (QuotaRootResolver)quotaRootResolver, (MetricFactory)new DefaultMetricFactory()));
    }

    public boolean supports(ImapFeatures.Feature ... features) {
        return IMAP_FEATURES.supports(features);
    }

    public void setQuotaLimits(QuotaCountLimit maxMessageQuota, QuotaSizeLimit maxStorageQuota) {
        this.perUserMaxQuotaManager.setGlobalMaxMessage(maxMessageQuota);
        this.perUserMaxQuotaManager.setGlobalMaxStorage(maxStorageQuota);
    }

    public MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    protected void await() {
    }
}

