/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.cassandra;

import java.util.List;
import java.util.Locale;
import org.apache.james.backends.cassandra.StatementRecorder;
import org.apache.james.mpt.api.ImapHostSystem;
import org.apache.james.mpt.imapmailbox.cassandra.host.CassandraHostSystem;
import org.apache.james.mpt.imapmailbox.cassandra.host.CassandraHostSystemExtension;
import org.apache.james.mpt.imapmailbox.suite.Listing;
import org.apache.james.mpt.script.SimpleScriptedTestProtocol;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CassandraListingTest
extends Listing {
    @RegisterExtension
    static CassandraHostSystemExtension hostSystemExtension = new CassandraHostSystemExtension();

    protected ImapHostSystem createImapHostSystem() {
        return hostSystemExtension.getImapHostSystem();
    }

    @Test
    public void listShouldNotReadCounters() throws Exception {
        CassandraHostSystem cassandraHostSystem = (CassandraHostSystem)this.system;
        StatementRecorder statementRecorder = new StatementRecorder();
        cassandraHostSystem.getCassandra().getConf().recordStatements(statementRecorder);
        ((SimpleScriptedTestProtocol)this.simpleScriptedTestProtocol.withLocale(Locale.US)).run("ListOnly");
        Assertions.assertThat((List)statementRecorder.listExecutedStatements(StatementRecorder.Selector.preparedStatement((String)"SELECT unseen,count FROM mailboxCounters WHERE mailboxId=:mailboxId;"))).isEmpty();
    }
}

