/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.external.james.host.external;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.UserAdder;
import org.apache.james.mpt.host.ExternalHostSystem;
import org.apache.james.mpt.imapmailbox.external.james.host.external.ExternalJamesConfiguration;
import org.apache.james.mpt.imapmailbox.external.james.host.external.NoopDomainsAndUserAdder;
import org.apache.james.mpt.monitor.NullMonitor;

@Singleton
public class ExternalJamesImapHostSystem
extends ExternalHostSystem {
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT});
    private static final String SHABANG = "* OK IMAP4rev1 Server ready";
    private final Supplier<InetSocketAddress> addressSupplier = () -> new InetSocketAddress(configuration.getAddress(), configuration.getImapPort().getValue());

    @Inject
    private ExternalJamesImapHostSystem(NoopDomainsAndUserAdder userAdder, ExternalJamesConfiguration configuration) {
        super(SUPPORTED_FEATURES, (Monitor)new NullMonitor(), SHABANG, (UserAdder)userAdder);
    }

    protected InetSocketAddress getAddress() {
        return this.addressSupplier.get();
    }

    public boolean addUser(Username user, String password) throws Exception {
        return super.addUser(user, password);
    }

    public void beforeTest() throws Exception {
    }

    public void afterTest() throws Exception {
    }

    public void createMailbox(MailboxPath mailboxPath) {
        throw new NotImplementedException("Not implemented");
    }

    public void setQuotaLimits(QuotaCountLimit maxMessageQuota, QuotaSizeLimit maxStorageQuota) throws Exception {
        throw new NotImplementedException("Not implemented");
    }
}

