/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.external.james.host.external;

import com.google.common.base.Preconditions;
import org.apache.james.mpt.imapmailbox.external.james.host.external.ExternalJamesConfiguration;
import org.apache.james.util.Port;

public class ExternalJamesConfigurationEnvironnementVariables
implements ExternalJamesConfiguration {
    private static final String ENV_JAMES_ADDRESS = "JAMES_ADDRESS";
    private static final String ENV_JAMES_IMAP_PORT = "JAMES_IMAP_PORT";
    private static final String ENV_JAMES_SMTP_PORT = "JAMES_SMTP_PORT";
    private final String address;
    private final Port imapPort;
    private final Port smtpPort;

    public ExternalJamesConfigurationEnvironnementVariables() {
        Preconditions.checkState((System.getenv(ENV_JAMES_ADDRESS) != null ? 1 : 0) != 0, (Object)"You must have exported an environment variable called JAMES_ADDRESS in order to run these tests. For instance export JAMES_ADDRESS=127.0.0.1");
        Preconditions.checkState((System.getenv(ENV_JAMES_IMAP_PORT) != null ? 1 : 0) != 0, (Object)"You must have exported an environment variable called JAMES_IMAP_PORT in order to run these tests. For instance export JAMES_IMAP_PORT=143");
        Preconditions.checkState((System.getenv(ENV_JAMES_SMTP_PORT) != null ? 1 : 0) != 0, (Object)"You must have exported an environment variable called JAMES_SMTP_PORT in order to run these tests. For instance export JAMES_IMAP_PORT=587");
        this.address = System.getenv(ENV_JAMES_ADDRESS);
        this.imapPort = Port.of((int)Integer.parseInt(System.getenv(ENV_JAMES_IMAP_PORT)));
        this.smtpPort = Port.of((int)Integer.parseInt(System.getenv(ENV_JAMES_SMTP_PORT)));
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public Port getImapPort() {
        return this.imapPort;
    }

    @Override
    public Port getSmptPort() {
        return this.smtpPort;
    }
}

