/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.external.james.host.docker;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.Username;
import org.apache.james.mpt.imapmailbox.external.james.ProvisioningException;
import org.apache.james.mpt.imapmailbox.external.james.host.ProvisioningAPI;
import org.apache.james.util.docker.DockerContainer;
import org.testcontainers.containers.Container;

public class CliProvisioningAPI
implements ProvisioningAPI {
    private final DockerContainer container;
    private final String[] cmd;
    private static final String[] jarCmd = new String[]{"java", "-jar", "/root/james-cli.jar"};
    private static final String[] hostAndPort = new String[]{"-h", "127.0.0.1", "-p", "9999"};

    public CliProvisioningAPI(CliType cliType, DockerContainer container) throws InterruptedException, ProvisioningException, IOException, IllegalArgumentException {
        this.container = container;
        switch (cliType.ordinal()) {
            case 0: {
                this.cmd = jarCmd;
                break;
            }
            case 1: {
                this.cmd = this.shCmd();
                break;
            }
            default: {
                throw new IllegalArgumentException("UNKNOWN CliType");
            }
        }
    }

    public void addDomain(String domain) throws Exception {
        Container.ExecResult execResult = this.exec("adddomain", domain);
        if (execResult.getExitCode() != 0) {
            throw new ProvisioningException("Failed to add domain" + this.executionResultToString(execResult));
        }
    }

    public void addUser(Username user, String password) throws Exception {
        Container.ExecResult execResult = this.exec("adduser", user.asString(), password);
        if (execResult.getExitCode() != 0) {
            throw new ProvisioningException("Failed to add user" + this.executionResultToString(execResult));
        }
    }

    private String[] shCmd() throws IOException, InterruptedException, ProvisioningException {
        Container.ExecResult findCli = this.container.exec(new String[]{"find", "/root", "-name", "james-cli.sh"});
        if (findCli.getExitCode() != 0) {
            throw new ProvisioningException("Failed to getCliPath" + this.executionResultToString(findCli));
        }
        return new String[]{findCli.getStdout().trim()};
    }

    private Container.ExecResult exec(String ... commands) throws Exception {
        String[] command = (String[])ArrayUtils.addAll((Object[])((String[])ArrayUtils.addAll((Object[])this.cmd, (Object[])hostAndPort)), (Object[])commands);
        return this.container.exec(command);
    }

    private String executionResultToString(Container.ExecResult execResult) {
        return StringUtils.join((Iterable)ImmutableList.of((Object)execResult.getStdout(), (Object)execResult.getStderr()), (String)" ");
    }

    public static enum CliType {
        JAR,
        SH;

    }
}

