/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.external.james;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.james.mpt.api.ImapHostSystem;
import org.apache.james.mpt.imapmailbox.external.james.DeploymentValidation;
import org.apache.james.mpt.imapmailbox.external.james.ExternalJamesModule;
import org.apache.james.mpt.imapmailbox.external.james.host.SmtpHostSystem;
import org.apache.james.mpt.imapmailbox.external.james.host.external.ExternalJamesConfiguration;
import org.apache.james.mpt.imapmailbox.external.james.host.external.ExternalJamesConfigurationEnvironnementVariables;
import org.apache.james.mpt.imapmailbox.external.james.host.external.NoopDomainsAndUserAdder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

class JamesDeploymentValidationTest
extends DeploymentValidation {
    private ImapHostSystem system;
    private SmtpHostSystem smtpHostSystem;
    private final ExternalJamesConfiguration configuration = new ExternalJamesConfigurationEnvironnementVariables();

    JamesDeploymentValidationTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ExternalJamesModule(this.configuration, new NoopDomainsAndUserAdder())});
        this.system = (ImapHostSystem)injector.getInstance(ImapHostSystem.class);
        this.smtpHostSystem = (SmtpHostSystem)injector.getInstance(SmtpHostSystem.class);
        this.system.beforeTest();
        super.setUp();
    }

    @Override
    protected ImapHostSystem createImapHostSystem() {
        return this.system;
    }

    @Override
    protected SmtpHostSystem createSmtpHostSystem() {
        return this.smtpHostSystem;
    }

    @Override
    protected ExternalJamesConfiguration getConfiguration() {
        return this.configuration;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.system.afterTest();
    }
}

