/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.external.james;

import java.io.IOException;
import org.apache.james.mpt.imapmailbox.external.james.ProvisioningException;
import org.apache.james.mpt.imapmailbox.external.james.host.ProvisioningAPI;
import org.apache.james.mpt.imapmailbox.external.james.host.StaticJamesConfiguration;
import org.apache.james.mpt.imapmailbox.external.james.host.docker.CliProvisioningAPI;
import org.apache.james.mpt.imapmailbox.external.james.host.external.ExternalJamesConfiguration;
import org.apache.james.util.Port;
import org.apache.james.util.docker.DockerContainer;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class DockerJamesRule
implements TestRule,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerJamesRule.class);
    private static final int IMAP_PORT = 143;
    private static final int SMTP_PORT = 587;
    private static final int WEBADMIN_PORT = 8000;
    private final DockerContainer container;

    public DockerJamesRule(String image) {
        this.container = DockerContainer.fromName((String)image).withExposedPorts(new Integer[]{587, 143}).waitingFor((WaitStrategy)new HostPortWaitStrategy()).withLogConsumer(frame -> {
            switch (frame.getType()) {
                case STDOUT: {
                    LOGGER.info(frame.getUtf8String());
                    break;
                }
                case STDERR: {
                    LOGGER.error(frame.getUtf8String());
                    break;
                }
            }
        });
    }

    public ProvisioningAPI cliJarDomainsAndUsersAdder() throws InterruptedException, ProvisioningException, IOException {
        return new CliProvisioningAPI(CliProvisioningAPI.CliType.JAR, this.container);
    }

    public ProvisioningAPI cliShellDomainsAndUsersAdder() throws InterruptedException, ProvisioningException, IOException {
        return new CliProvisioningAPI(CliProvisioningAPI.CliType.SH, this.container);
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public void pause() {
        this.container.pause();
    }

    public void unpause() {
        this.container.unpause();
    }

    public ExternalJamesConfiguration getConfiguration() {
        return new StaticJamesConfiguration("localhost", this.getMappedPort(143), this.getMappedPort(587));
    }

    public Port getWebadminPort() {
        return this.getMappedPort(8000);
    }

    private Port getMappedPort(int port) {
        return Port.of((int)this.container.getMappedPort(port));
    }

    public Statement apply(Statement statement, Description description) {
        return statement;
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.stop();
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.start();
    }
}

