/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.external.james;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.james.core.Username;
import org.apache.james.mpt.api.ImapHostSystem;
import org.apache.james.mpt.imapmailbox.external.james.DeploymentValidation;
import org.apache.james.mpt.imapmailbox.external.james.DockerJamesRule;
import org.apache.james.mpt.imapmailbox.external.james.ExternalJamesModule;
import org.apache.james.mpt.imapmailbox.external.james.host.ProvisioningAPI;
import org.apache.james.mpt.imapmailbox.external.james.host.SmtpHostSystem;
import org.apache.james.mpt.imapmailbox.external.james.host.external.ExternalJamesConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Disabled(value="Not to be run on CI, as it will not use the current build")
class DockerDeploymentValidationGuiceJPATest
extends DeploymentValidation {
    private ImapHostSystem system;
    private SmtpHostSystem smtpHostSystem;
    @RegisterExtension
    public DockerJamesRule dockerJamesRule = new DockerJamesRule("linagora/james-jpa-guice");

    DockerDeploymentValidationGuiceJPATest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.dockerJamesRule.start();
        ProvisioningAPI provisioningAPI = this.dockerJamesRule.cliJarDomainsAndUsersAdder();
        Injector injector = Guice.createInjector((Module[])new Module[]{new ExternalJamesModule(this.getConfiguration(), provisioningAPI)});
        provisioningAPI.addDomain("domain");
        provisioningAPI.addUser(Username.of((String)"imapuser@domain"), "password");
        this.system = (ImapHostSystem)injector.getInstance(ImapHostSystem.class);
        this.smtpHostSystem = (SmtpHostSystem)injector.getInstance(SmtpHostSystem.class);
        this.system.beforeTest();
        super.setUp();
    }

    @Override
    @Test
    @Disabled(value="Not to be run on CI, as it will not use the current build. Uncomment to test on local dev environment")
    public void validateDeployment() throws Exception {
    }

    @Override
    @Test
    @Disabled(value="Not to be run on CI, as it will not use the current build. Uncomment to test on local dev environment")
    public void validateDeploymentWithMailsFromSmtp() throws Exception {
    }

    @Override
    protected ImapHostSystem createImapHostSystem() {
        return this.system;
    }

    @Override
    protected SmtpHostSystem createSmtpHostSystem() {
        return this.smtpHostSystem;
    }

    @Override
    protected ExternalJamesConfiguration getConfiguration() {
        return this.dockerJamesRule.getConfiguration();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.system.afterTest();
        this.dockerJamesRule.stop();
    }
}

