/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.external.james;

import java.io.IOException;
import java.time.Duration;
import java.util.Locale;
import org.apache.commons.net.imap.IMAPClient;
import org.apache.james.mpt.api.HostSystem;
import org.apache.james.mpt.api.ImapHostSystem;
import org.apache.james.mpt.imapmailbox.external.james.host.SmtpHostSystem;
import org.apache.james.mpt.imapmailbox.external.james.host.external.ExternalJamesConfiguration;
import org.apache.james.mpt.script.SimpleScriptedTestProtocol;
import org.apache.james.utils.SMTPMessageSender;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DeploymentValidation {
    public static final String DOMAIN = "domain";
    public static final String USER = "imapuser";
    public static final String USER_ADDRESS = "imapuser@domain";
    public static final String PASSWORD = "password";
    private static final String INBOX = "INBOX";
    private static final String ONE_MAIL = "* 1 EXISTS";
    private ImapHostSystem system;
    private SmtpHostSystem smtpSystem;
    private SimpleScriptedTestProtocol simpleScriptedTestProtocol;
    private IMAPClient imapClient = new IMAPClient();
    protected static final Duration slowPacedPollInterval = Durations.ONE_HUNDRED_MILLISECONDS;
    protected static final ConditionFactory calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
    protected static final ConditionFactory awaitAtMostTenSeconds = calmlyAwait.atMost(Durations.TEN_SECONDS);

    protected abstract ImapHostSystem createImapHostSystem();

    protected abstract SmtpHostSystem createSmtpHostSystem();

    protected abstract ExternalJamesConfiguration getConfiguration();

    @BeforeEach
    public void setUp() throws Exception {
        this.system = this.createImapHostSystem();
        this.smtpSystem = this.createSmtpHostSystem();
        this.simpleScriptedTestProtocol = (SimpleScriptedTestProtocol)((SimpleScriptedTestProtocol)new SimpleScriptedTestProtocol("/org/apache/james/imap/scripts/", (HostSystem)this.system).withUser(USER_ADDRESS, PASSWORD)).withLocale(Locale.US);
    }

    @Test
    public void validateDeployment() throws Exception {
        this.simpleScriptedTestProtocol.run("ValidateDeployment");
    }

    @Test
    public void selectThenFetchWithExistingMessages() throws Exception {
        this.simpleScriptedTestProtocol.run("SelectThenFetchWithExistingMessages");
    }

    @Test
    public void validateDeploymentWithMailsFromSmtp() throws Exception {
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("another-domain");
        this.smtpSystem.connect(smtpMessageSender).authenticate(USER_ADDRESS, PASSWORD).sendMessage(USER_ADDRESS, USER_ADDRESS);
        this.imapClient.connect(this.getConfiguration().getAddress(), this.getConfiguration().getImapPort().getValue());
        this.imapClient.login(USER_ADDRESS, PASSWORD);
        awaitAtMostTenSeconds.until(this::checkMailDelivery);
    }

    private Boolean checkMailDelivery() throws IOException {
        this.imapClient.select(INBOX);
        String replyString = this.imapClient.getReplyString();
        return replyString.contains(ONE_MAIL);
    }
}

