/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.clamav;

import java.time.Duration;
import java.util.UUID;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class DockerClamAV {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"clamav/clamav").withTag("1.3");
    private static final int DEFAULT_PORT = 3310;
    private final GenericContainer<?> container = new GenericContainer(DEFAULT_IMAGE_NAME).withExposedPorts(new Integer[]{3310}).withEnv("CLAMAV_NO_FRESHCLAMD", "true").withEnv("CLAMAV_NO_MILTERD", "true").withCreateContainerCmdModifier(createContainerCmd -> createContainerCmd.withName("james-clamav-test-" + String.valueOf(UUID.randomUUID()))).waitingFor(Wait.forHealthcheck().withStartupTimeout(Duration.ofMinutes(5L)));

    public Integer getPort() {
        return this.container.getMappedPort(3310);
    }

    public void start() {
        if (!this.container.isRunning()) {
            this.container.start();
        }
    }

    public void stop() {
        this.container.stop();
    }
}

