/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.clamav;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.InputStream;
import java.util.Optional;
import org.apache.james.clamav.ClamAVScan;
import org.apache.james.clamav.DockerClamAV;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ClamAVScanTest {
    private static final DockerClamAV dockerClamAV = new DockerClamAV();
    private ClamAVScan clamAVScan;

    ClamAVScanTest() {
    }

    @BeforeEach
    public void setUp() throws MessagingException {
        this.clamAVScan = new ClamAVScan();
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("host", "localhost").setProperty("port", dockerClamAV.getPort().toString()).build();
        this.clamAVScan.init((MailetConfig)mailetConfig);
    }

    @BeforeAll
    static void setup() {
        dockerClamAV.start();
    }

    @AfterAll
    static void teardown() {
        dockerClamAV.stop();
    }

    @Test
    void testHasVirusFunctionForVirusMail() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("attachment/inlineVirusTextAttachment.eml"));
        MimeMessageInputStream mimeMessageInputStream = new MimeMessageInputStream(mimeMessage);
        Assertions.assertThat((boolean)this.clamAVScan.hasVirus((InputStream)mimeMessageInputStream)).isTrue();
    }

    @Test
    void testHasVirusFunctionForNonVirusMail() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("attachment/inlineNonVirusTextAttachment.eml"));
        MimeMessageInputStream mimeMessageInputStream = new MimeMessageInputStream(mimeMessage);
        Assertions.assertThat((boolean)this.clamAVScan.hasVirus((InputStream)mimeMessageInputStream)).isFalse();
    }

    @Test
    void mailetShouldMarkInfectedHeaderAndMailAttributeAsTrueWhenMailHasVirus() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("attachment/inlineVirusTextAttachment.eml"));
        FakeMail mail = FakeMail.builder().name("name").recipient("user1@example.com").mimeMessage(mimeMessage).build();
        this.clamAVScan.service((Mail)mail);
        Assertions.assertThat((Object)((Attribute)mail.getAttribute(ClamAVScan.INFECTED_MAIL_ATTRIBUTE_NAME).get()).getValue().value()).isEqualTo((Object)true);
        Assertions.assertThat((String)mail.getMessage().getHeader("X-MessageIsInfected")[0]).isEqualTo("true");
    }

    @Test
    void mailetShouldMarkInfectedHeaderAndMailAttributeAsFalseWhenMailHasNoVirus() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("attachment/inlineNonVirusTextAttachment.eml"));
        FakeMail mail = FakeMail.builder().name("name").recipient("user1@example.com").mimeMessage(mimeMessage).build();
        this.clamAVScan.service((Mail)mail);
        Assertions.assertThat((Object)((Attribute)mail.getAttribute(ClamAVScan.INFECTED_MAIL_ATTRIBUTE_NAME).get()).getValue().value()).isEqualTo((Object)false);
        Assertions.assertThat((String)mail.getMessage().getHeader("X-MessageIsInfected")[0]).isEqualTo("false");
    }

    @Test
    void mailedShouldWorkWellWhenScanningContinuousMails() throws Exception {
        MimeMessage virusMimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("attachment/inlineVirusTextAttachment.eml"));
        FakeMail virusMail = FakeMail.builder().name("name").recipient("user1@example.com").mimeMessage(virusMimeMessage).build();
        MimeMessage nonVirusMimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("attachment/inlineNonVirusTextAttachment.eml"));
        FakeMail nonVirusMail = FakeMail.builder().name("name").recipient("user1@example.com").mimeMessage(nonVirusMimeMessage).build();
        this.clamAVScan.service((Mail)virusMail);
        this.clamAVScan.service((Mail)nonVirusMail);
        Assertions.assertThat((String)virusMail.getMessage().getHeader("X-MessageIsInfected")[0]).isEqualTo("true");
        Assertions.assertThat((String)nonVirusMail.getMessage().getHeader("X-MessageIsInfected")[0]).isEqualTo("false");
    }

    @Test
    void mailetShouldNotMarkHeaderAndMailAttributeAndJustLogErrorWhenCanNotConnectToClamAV() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("attachment/inlineVirusTextAttachment.eml"));
        FakeMail mail = FakeMail.builder().name("name").recipient("user1@example.com").mimeMessage(mimeMessage).build();
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("host", "localhost").setProperty("port", "0").setProperty("maxPings", "0").build();
        this.clamAVScan.init((MailetConfig)mailetConfig);
        this.clamAVScan.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ClamAVScan.INFECTED_MAIL_ATTRIBUTE_NAME)).isEmpty();
        Assertions.assertThat((Object[])mail.getMessage().getHeader("X-MessageIsInfected")).isNull();
    }
}

