/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.cindy.util.ByteBufferUtils;
import net.sf.jml.MsnProtocol;
import net.sf.jml.util.Charset;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringUtils;

public abstract class MsnMessage {
    private String command;
    private int trId = -1;
    private final List<String> params = new ArrayList<String>();
    private byte[] chunkData;
    protected final MsnProtocol protocol;
    private static final Pattern noChunkPattern = Pattern.compile("(\\S{3})(.*)");
    private static final Pattern chunkPattern = Pattern.compile("(\\S{3})(.*) (\\d+)");
    private static final ByteBuffer split = Charset.encode("\r\n");

    protected MsnMessage(MsnProtocol msnProtocol) {
        this.protocol = msnProtocol;
    }

    public final MsnProtocol getProtocol() {
        return this.protocol;
    }

    public final int getTransactionId() {
        return this.trId;
    }

    public final String getCommand() {
        return this.command;
    }

    protected boolean isSupportTransactionId() {
        return true;
    }

    final void setTransactionId(int n) {
        if (this.isSupportTransactionId()) {
            this.trId = n;
        }
    }

    protected final void setCommand(String string) {
        this.command = string;
    }

    protected final String getParam(int n) {
        if (n < this.params.size()) {
            return this.params.get(n);
        }
        return null;
    }

    protected final int getParamCount() {
        return this.params.size();
    }

    protected final void setParam(int n, String string) {
        for (int i = this.params.size() - n - 1; i < 0; ++i) {
            this.params.add("");
        }
        this.params.set(n, string);
    }

    protected final void addParam(String string) {
        if (string != null) {
            this.params.add(string);
        }
    }

    protected final void clearParams() {
        this.params.clear();
    }

    protected boolean isSupportChunkData() {
        return false;
    }

    protected final byte[] getChunkData() {
        return this.chunkData;
    }

    protected final void setChunkData(byte[] byArray) {
        if (this.isSupportChunkData()) {
            this.chunkData = byArray;
        }
    }

    protected final void setChunkData(String string) {
        this.chunkData = Charset.encodeAsByteArray(string);
    }

    protected boolean load(ByteBuffer byteBuffer) {
        int n = ByteBufferUtils.indexOf((ByteBuffer)byteBuffer, (ByteBuffer)split);
        if (n < 0) {
            return false;
        }
        String string = Charset.decode((ByteBuffer)byteBuffer.slice().limit(n - byteBuffer.position()));
        Matcher matcher = this.isSupportChunkData() ? chunkPattern.matcher(string) : noChunkPattern.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        if (this.isSupportChunkData()) {
            int n2 = NumberUtils.stringToInt(matcher.group(3));
            if (byteBuffer.limit() < n + split.remaining() + n2) {
                return false;
            }
            byteBuffer.position(n + split.remaining());
            this.chunkData = new byte[n2];
            byteBuffer.get(this.chunkData);
        } else {
            byteBuffer.position(n + split.remaining());
        }
        this.setCommand(matcher.group(1));
        String string2 = matcher.group(2);
        if (string2 != null) {
            this.clearParams();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (this.isSupportTransactionId() && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (NumberUtils.isDigits(string3)) {
                    this.setTransactionId(NumberUtils.stringToInt(string3));
                } else {
                    this.addParam(string3);
                }
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.addParam(stringTokenizer.nextToken());
            }
        }
        return true;
    }

    private String bodyToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.command);
        if (this.trId >= 0) {
            stringBuffer.append(" ").append(this.trId);
        }
        for (String string : this.params) {
            stringBuffer.append(" ").append(string);
        }
        if (this.chunkData != null) {
            stringBuffer.append(" ").append(this.chunkData.length);
        }
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    protected ByteBuffer[] save() {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.chunkData == null ? 1 : 2];
        byteBufferArray[0] = Charset.encode(this.bodyToString());
        if (this.chunkData != null) {
            byteBufferArray[1] = ByteBuffer.wrap(this.chunkData);
        }
        return byteBufferArray;
    }

    public String toString() {
        if (this.chunkData == null) {
            return this.bodyToString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.bodyToString());
        stringBuffer.append("====================").append("\r\n");
        stringBuffer.append("     Chunk Debug    ").append("\r\n");
        stringBuffer.append("====================").append("\r\n");
        stringBuffer.append(Charset.decode(this.chunkData)).append("\r\n");
        stringBuffer.append("====================").append("\r\n");
        stringBuffer.append(" Binary Chunk Debug ").append("\r\n");
        stringBuffer.append("====================").append("\r\n");
        stringBuffer.append(StringUtils.debug(ByteBuffer.wrap(this.chunkData)));
        return stringBuffer.toString();
    }

    public String asString() {
        if (this.chunkData == null) {
            return this.bodyToString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.bodyToString());
        stringBuffer.append(Charset.decode(this.chunkData));
        return stringBuffer.toString();
    }
}

