/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.cindy.util.ByteBufferUtils;
import net.sf.jml.message.p2p.MsnP2PAckMessage;
import net.sf.jml.message.p2p.MsnP2PByeAckMessage;
import net.sf.jml.message.p2p.MsnP2PByeMessage;
import net.sf.jml.message.p2p.MsnP2PDataMessage;
import net.sf.jml.message.p2p.MsnP2PInvitationMessage;
import net.sf.jml.message.p2p.MsnP2PMessage;
import net.sf.jml.message.p2p.MsnP2PPreperationMessage;
import net.sf.jml.message.p2p.MsnP2PSlpMessage;
import net.sf.jml.protocol.msnslp.MsnslpMessage;
import net.sf.jml.protocol.msnslp.MsnslpRequest;
import net.sf.jml.util.Charset;

public class MsnP2PMessageFactory {
    public static MsnP2PMessage parseMessage(byte[] byArray) {
        MsnP2PMessage msnP2PMessage = MsnP2PMessageFactory.recognizeMessage(byArray);
        msnP2PMessage.parseMessage(byArray);
        return msnP2PMessage;
    }

    private static MsnP2PMessage recognizeMessage(byte[] byArray) {
        ByteBuffer byteBuffer = Charset.encode("\r\n\r\n");
        int n = ByteBufferUtils.indexOf((ByteBuffer)ByteBuffer.wrap(byArray), (ByteBuffer)byteBuffer);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(48).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer2.put(byArray, n += byteBuffer.remaining(), 48);
        byteBuffer2.flip();
        int n2 = byteBuffer2.getInt(0);
        int n3 = byteBuffer2.getInt(28);
        int n4 = byteBuffer2.getInt(24);
        long l = byteBuffer2.getLong(16);
        n += 48;
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(4);
        byteBuffer3.put(byArray, byArray.length - 4, 4);
        byteBuffer3.flip();
        int n5 = byteBuffer3.getInt(0);
        if (n3 == 2) {
            return new MsnP2PAckMessage();
        }
        if (n3 == 64) {
            return new MsnP2PByeAckMessage();
        }
        if (n3 == 32) {
            return new MsnP2PDataMessage();
        }
        if (n3 == 0 && l == 4L && n4 == 4 && n2 != 0) {
            return new MsnP2PPreperationMessage();
        }
        if (n3 == 0 && n2 == 0 && l == (long)n4) {
            MsnP2PSlpMessage msnP2PSlpMessage = new MsnP2PSlpMessage();
            msnP2PSlpMessage.parseMessage(byArray);
            MsnslpMessage msnslpMessage = msnP2PSlpMessage.getSlpMessage();
            if (msnslpMessage instanceof MsnslpRequest) {
                MsnslpRequest msnslpRequest = (MsnslpRequest)msnP2PSlpMessage.getSlpMessage();
                if (msnslpRequest.getRequestMethod() != null && msnslpRequest.getRequestMethod().equals("BYE")) {
                    return new MsnP2PByeMessage();
                }
                if (msnslpRequest.getRequestMethod() != null && msnslpRequest.getRequestMethod().equals("INVITE")) {
                    return new MsnP2PInvitationMessage();
                }
            }
            return msnP2PSlpMessage;
        }
        return new MsnP2PDataMessage();
    }
}

