/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import net.sf.jml.Email;
import net.sf.jml.MsnClientId;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnObject;
import net.sf.jml.MsnOwner;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnUserPropertyType;
import net.sf.jml.MsnUserStatus;
import net.sf.jml.impl.MsnUserImpl;
import net.sf.jml.protocol.outgoing.OutgoingBLP;
import net.sf.jml.protocol.outgoing.OutgoingCHG;
import net.sf.jml.protocol.outgoing.OutgoingGTC;
import net.sf.jml.protocol.outgoing.OutgoingPRP;
import net.sf.jml.protocol.outgoing.OutgoingREA;
import net.sf.jml.protocol.outgoing.OutgoingUUX;
import net.sf.jml.util.GUID;
import net.sf.jml.util.StringUtils;

public class MsnOwnerImpl
extends MsnUserImpl
implements MsnOwner {
    private final MsnMessenger messenger;
    private final String password;
    private boolean verified;
    private boolean onlyNotifyAllowList;
    private boolean notifyMeWhenSomeoneAddedMe;
    private MsnUserStatus initStatus = MsnUserStatus.ONLINE;
    private MsnObject displayPicture;
    private String personalMessage = "";

    public MsnOwnerImpl(MsnMessenger msnMessenger, Email email, String string) {
        this.messenger = msnMessenger;
        this.password = string;
        this.setEmail(email);
    }

    public MsnMessenger getMessenger() {
        return this.messenger;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public MsnUserStatus getInitStatus() {
        return this.initStatus;
    }

    public void setInitStatus(MsnUserStatus msnUserStatus) {
        if (msnUserStatus == MsnUserStatus.OFFLINE) {
            throw new IllegalArgumentException(msnUserStatus.toString());
        }
        this.initStatus = msnUserStatus;
    }

    public boolean isOnlyNotifyAllowList() {
        return this.onlyNotifyAllowList;
    }

    public boolean isNotifyMeWhenSomeoneAddedMe() {
        return this.notifyMeWhenSomeoneAddedMe;
    }

    public void setDisplayName(String string) {
        if (string != null) {
            if (string.equals(this.getDisplayName())) {
                return;
            }
            MsnProtocol msnProtocol = this.messenger.getActualMsnProtocol();
            if (msnProtocol.after(MsnProtocol.MSNP9)) {
                this.setProperty(MsnUserPropertyType.MFN, StringUtils.urlEncode(string));
            } else {
                OutgoingREA outgoingREA = new OutgoingREA(msnProtocol);
                outgoingREA.setId(this.getEmail().getEmailAddress());
                outgoingREA.setFriendlyName(string);
                this.messenger.send(outgoingREA);
            }
            super.setDisplayName(string);
        }
    }

    public void setClientId(MsnClientId msnClientId) {
        if (msnClientId != null && !msnClientId.equals(this.getClientId())) {
            OutgoingCHG outgoingCHG = new OutgoingCHG(this.messenger.getActualMsnProtocol());
            outgoingCHG.setClientId(msnClientId);
            outgoingCHG.setStatus(this.getStatus());
            outgoingCHG.setDisplayPicture(this.getDisplayPicture());
            this.messenger.send(outgoingCHG);
        }
    }

    public void setStatus(MsnUserStatus msnUserStatus) {
        if (msnUserStatus != null && msnUserStatus != MsnUserStatus.OFFLINE && msnUserStatus != this.getStatus()) {
            OutgoingCHG outgoingCHG = new OutgoingCHG(this.messenger.getActualMsnProtocol());
            outgoingCHG.setClientId(this.getClientId());
            outgoingCHG.setStatus(msnUserStatus);
            outgoingCHG.setDisplayPicture(this.getDisplayPicture());
            this.messenger.send(outgoingCHG);
        }
    }

    public void setPersonalMessage(String string) {
        OutgoingUUX outgoingUUX = new OutgoingUUX(this.messenger.getActualMsnProtocol());
        outgoingUUX.setPersonalMessage(string);
        this.messenger.send(outgoingUUX);
        this.personalMessage = string;
    }

    public void setCurrentMedia(String string) {
        OutgoingUUX outgoingUUX = new OutgoingUUX(this.messenger.getActualMsnProtocol());
        outgoingUUX.setCurrentMedia(string);
        this.messenger.send(outgoingUUX);
    }

    public void setCurrentMedia(String string, String string2, String string3, GUID gUID) {
        OutgoingUUX outgoingUUX = new OutgoingUUX(this.messenger.getActualMsnProtocol());
        outgoingUUX.setCurrentMedia(string, string2, string3, gUID);
        this.messenger.send(outgoingUUX);
    }

    public void setPersonalMessageAndCurrentMedia(String string, String string2) {
        OutgoingUUX outgoingUUX = new OutgoingUUX(this.messenger.getActualMsnProtocol());
        outgoingUUX.setPersonalMessage(string);
        outgoingUUX.setCurrentMedia(string2);
        this.messenger.send(outgoingUUX);
    }

    public void setPersonalMessageAndCurrentMedia(String string, String string2, String string3, String string4, GUID gUID) {
        OutgoingUUX outgoingUUX = new OutgoingUUX(this.messenger.getActualMsnProtocol());
        outgoingUUX.setPersonalMessage(string);
        outgoingUUX.setCurrentMedia(string2, string3, string4, gUID);
        this.messenger.send(outgoingUUX);
    }

    public void setDisplayPicture(MsnObject msnObject) {
        if (msnObject != null && !msnObject.equals(this.displayPicture)) {
            this.setInitDisplayPicture(msnObject);
            OutgoingCHG outgoingCHG = new OutgoingCHG(this.messenger.getActualMsnProtocol());
            outgoingCHG.setClientId(this.getClientId());
            outgoingCHG.setStatus(this.getStatus());
            outgoingCHG.setDisplayPicture(this.getDisplayPicture());
            this.messenger.send(outgoingCHG);
        }
    }

    public void setProperty(MsnUserPropertyType msnUserPropertyType, String string) {
        if (msnUserPropertyType != null) {
            OutgoingPRP outgoingPRP = new OutgoingPRP(this.messenger.getActualMsnProtocol());
            outgoingPRP.setPropertyType(msnUserPropertyType);
            outgoingPRP.setProperty(string);
            this.messenger.send(outgoingPRP);
        }
    }

    public void setOnlyNotifyAllowList(boolean bl) {
        if (bl != this.isOnlyNotifyAllowList()) {
            OutgoingBLP outgoingBLP = new OutgoingBLP(this.messenger.getActualMsnProtocol());
            outgoingBLP.setOnlyNotifyAllowList(bl);
            this.messenger.send(outgoingBLP);
        }
    }

    public void setNotifyMeWhenSomeoneAddedMe(boolean bl) {
        if (bl != this.isNotifyMeWhenSomeoneAddedMe()) {
            OutgoingGTC outgoingGTC = new OutgoingGTC(this.messenger.getActualMsnProtocol());
            outgoingGTC.setNotifyMeWhenSomeoneAddedMe(bl);
            this.messenger.send(outgoingGTC);
        }
    }

    public String toString() {
        return "MsnOwner: [Email] " + this.getEmail() + " [DisplayName] " + this.getDisplayName() + " [Status] " + this.getStatus();
    }

    public void setVerified(boolean bl) {
        this.verified = bl;
    }

    public void setInitDisplayPicture(MsnObject msnObject) {
        this.displayPicture = msnObject;
        if (msnObject != null) {
            this.messenger.getDisplayPictureDuelManager().setDisplayPicutre(msnObject);
        }
    }

    public void setInitPersonalMessage(String string) {
        this.personalMessage = string;
    }

    public String getPassword() {
        return this.password;
    }

    public MsnObject getDisplayPicture() {
        return this.displayPicture;
    }

    public String getPersonalMessage() {
        return this.personalMessage;
    }

    public void fSetDisplayName(String string) {
        super.setDisplayName(string);
    }

    public void fSetClientId(MsnClientId msnClientId) {
        super.setClientId(msnClientId);
    }

    public void fSetStatusF(MsnUserStatus msnUserStatus) {
        super.setStatus(msnUserStatus);
    }

    public void fSetNotifyMeWhenSomeoneAddedMe(boolean bl) {
        this.notifyMeWhenSomeoneAddedMe = bl;
    }

    public void fSetOnlyNotifyAllowList(boolean bl) {
        this.onlyNotifyAllowList = bl;
    }
}

