/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tigase.xml.Element;
import tigase.xml.ElementMatcher;

public class Path {
    private final ElementMatcher[] matchers;

    public static @NonNull Path parse(@NonNull String text) throws PathFormatException {
        Objects.requireNonNull(text, "String to parse as Path cannot be null!");
        if (!text.startsWith("/")) {
            throw new PathFormatException("Path cannot start without '/'");
        }
        State state = new State(text);
        state.text = state.text.substring(1);
        ArrayList<ElementMatcher> matchers = new ArrayList<ElementMatcher>();
        while (!state.text.isEmpty()) {
            matchers.add(ElementMatcher.parse(state));
            if (state.text.startsWith("/")) {
                state.text = state.text.substring(1);
                continue;
            }
            if (state.text.isEmpty()) continue;
            throw new PathFormatException("Path cannot have empty element name");
        }
        if (matchers.isEmpty()) {
            throw new PathFormatException("Path cannot be empty!");
        }
        return new Path((ElementMatcher[])matchers.toArray(ElementMatcher[]::new));
    }

    public static @NonNull Path of(String ... matcherStrings) throws PathFormatException {
        ArrayList<ElementMatcher> matchers = new ArrayList<ElementMatcher>();
        for (String str : matcherStrings) {
            matchers.add(ElementMatcher.parse(str));
        }
        return new Path((ElementMatcher[])matchers.toArray(ElementMatcher[]::new));
    }

    public static @NonNull Path of(ElementMatcher ... matchers) {
        if (matchers.length == 0) {
            throw new IllegalArgumentException("At least 1 matcher is required!");
        }
        return new Path(matchers);
    }

    public static @NonNull Path nameAndXmlns(@NonNull String name, @NonNull String xmlns) {
        return new Path(new ElementMatcher[]{new ElementMatcher(name, xmlns, Collections.emptyList())});
    }

    private Path(ElementMatcher[] matchers) {
        this.matchers = matchers;
    }

    public @Nullable Element evaluate(@NonNull Element element) {
        Objects.requireNonNull(element, "Element cannot be null!");
        Element el = element;
        if (!this.matchers[0].test(el)) {
            return null;
        }
        for (int i = 1; i < this.matchers.length; ++i) {
            if (el == null) {
                return null;
            }
            el = el.findChild(this.matchers[i]);
        }
        return el;
    }

    public @NonNull List<Element> evaluateAll(@NonNull Element element) {
        Objects.requireNonNull(element, "Element cannot be null!");
        if (!this.matchers[0].test(element)) {
            return Collections.emptyList();
        }
        List<Element> result = List.of(element);
        for (int i = 1; i < this.matchers.length; ++i) {
            ArrayList<Element> tmp = new ArrayList<Element>();
            for (Element el : result) {
                tmp.addAll(el.findChildren(this.matchers[i]));
            }
            result = tmp;
        }
        return result;
    }

    public Path then(ElementMatcher matcher) {
        Objects.requireNonNull(matcher, "ElementMatcher cannot be null!");
        ElementMatcher[] newMatchers = Arrays.copyOf(this.matchers, this.matchers.length + 1);
        newMatchers[this.matchers.length] = matcher;
        return new Path(newMatchers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ElementMatcher matcher : this.matchers) {
            sb.append("/");
            matcher.toStringBuilder(sb);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            return Arrays.equals(this.matchers, ((Path)obj).matchers);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.matchers);
    }

    public static class PathFormatException
    extends Throwable {
        public PathFormatException(String message) {
            super(message);
        }
    }

    protected static class State {
        String text;

        public State(String text) {
            this.text = text;
        }
    }
}

