/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tigase.xml.CData;
import tigase.xml.DomBuilderHandler;
import tigase.xml.ElementFilters;
import tigase.xml.Path;
import tigase.xml.SimpleParser;
import tigase.xml.XMLNodeIfc;

public class Element
implements XMLNodeIfc<Element> {
    private static final String ATTR_XMLNS_KEY = "xmlns";
    private static final Map<String, String> ATTRIBUTES_EMPTY = Collections.emptyMap();
    private static final List<XMLNodeIfc> NODES_EMPTY = Collections.emptyList();
    protected static BiFunction<String, String, String> elementNameDeduplicationFn = List.of("message", "iq", "presence", "query", "pubsub", "body", "stanza-id", "event").stream().collect(Collectors.toMap(Function.identity(), Function.identity()))::getOrDefault;
    protected static BiFunction<String, String, String> attributesDeduplicationFn = List.of("id", "name", "xmlns", "from", "to", "hash").stream().collect(Collectors.toMap(Function.identity(), Function.identity()))::getOrDefault;
    private @NonNull Map<String, String> attributes = ATTRIBUTES_EMPTY;
    private @NonNull List<XMLNodeIfc> nodes = NODES_EMPTY;
    private final String name;
    private String xmlns = null;

    static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("You must give file name as parameter.");
            System.exit(1);
        }
        FileReader file = new FileReader(args[0]);
        char[] buff = new char[1];
        SimpleParser parser = new SimpleParser();
        DomBuilderHandler dom = new DomBuilderHandler();
        int result = -1;
        while ((result = file.read(buff)) != -1) {
            parser.parse(dom, buff, 0, result);
        }
        file.close();
        Queue<Element> elems = dom.getParsedElements();
        for (Element elem : elems) {
            elem.clone();
            System.out.println(elem.toString());
        }
    }

    public Element(@NonNull Element src) {
        if (!src.attributes.isEmpty()) {
            this.attributes = new HashMap<String, String>(src.attributes);
        }
        this.name = src.name;
        this.xmlns = src.xmlns;
        if (!src.nodes.isEmpty()) {
            this.nodes = new ArrayList<XMLNodeIfc>(src.nodes);
        }
    }

    public Element(@NonNull String name) {
        this.name = elementNameDeduplicationFn.apply(name, name);
    }

    public @NonNull Element addCData(@NonNull String cdata) {
        this.addNode(new CData(cdata));
        return this;
    }

    public @NonNull Element addChild(@NonNull Element child) {
        Objects.requireNonNull(child, "Element child can not be null.");
        this.addNode(child);
        return this;
    }

    public @NonNull Element addChildren(@NonNull List<Element> children) {
        Objects.requireNonNull(children, "List of children cannot be null.");
        if (this.nodes == NODES_EMPTY) {
            this.nodes = new ArrayList<XMLNodeIfc>(children.size());
        }
        for (XMLNodeIfc xMLNodeIfc : children) {
            Objects.requireNonNull(xMLNodeIfc, "Element child can not be null.");
            this.nodes.add(xMLNodeIfc);
        }
        return this;
    }

    private void addNode(@NonNull XMLNodeIfc node) {
        if (this.nodes == NODES_EMPTY) {
            this.nodes = new ArrayList<XMLNodeIfc>();
        }
        this.nodes.add(node);
    }

    public void nodesToString(@NonNull StringBuilder result) {
        for (XMLNodeIfc node : this.nodes) {
            if (node instanceof Element) {
                ((Element)node).toString(result);
                continue;
            }
            result.append(node.toString());
        }
    }

    public void nodesToStringPretty(@NonNull StringBuilder result) {
        for (XMLNodeIfc node : this.nodes) {
            result.append(node.toStringPretty());
        }
    }

    public void nodesToStringSecure(@NonNull StringBuilder result) {
        for (XMLNodeIfc node : this.nodes) {
            if (node instanceof Element) {
                ((Element)node).toStringSecure(result);
                continue;
            }
            result.append(node.toStringSecure());
        }
    }

    @Override
    public Element clone() {
        return new Element(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Element)) {
            return false;
        }
        Element elem = (Element)obj;
        if (Objects.equals(this.getName(), elem.getName()) && Objects.equals(this.getXMLNS(), elem.getXMLNS())) {
            return Objects.equals(this.attributes, elem.attributes);
        }
        return false;
    }

    public @Nullable Element findChild(@NonNull Predicate<Element> predicate) {
        for (XMLNodeIfc node : this.nodes) {
            Element el;
            if (!(node instanceof Element) || !predicate.test(el = (Element)node)) continue;
            return el;
        }
        return null;
    }

    public @Nullable Element findChild(@NonNull String name) {
        return this.findChild(ElementFilters.name(name));
    }

    public @Nullable Element findChild(@NonNull String name, @NonNull String xmlns) {
        return this.findChild(ElementFilters.name(name).and(ElementFilters.xmlns(xmlns)));
    }

    public @Nullable Element findChildAt(@NonNull Path path) {
        return path.evaluate(this);
    }

    public @Nullable Element findChildAt(@NonNull Predicate<Element> predicate, Predicate<Element> ... path) {
        Element child = this.findChild(predicate);
        if (child == null) {
            return null;
        }
        for (Predicate<Element> pathPredicate : path) {
            if ((child = child.findChild(pathPredicate)) != null) continue;
            return null;
        }
        return child;
    }

    public @NonNull List<Element> findChildren(@NonNull Predicate<Element> predicate) {
        if (!this.nodes.isEmpty()) {
            LinkedList<Element> result = new LinkedList<Element>();
            this.forEachChild(el -> {
                if (predicate.test((Element)el)) {
                    result.add((Element)el);
                }
            });
            return result;
        }
        return Collections.emptyList();
    }

    public @NonNull List<Element> findChildrenAt(@NonNull Path path) {
        return path.evaluateAll(this);
    }

    public @Nullable String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public @Nullable String getAttributeAt(Path path, String name) {
        Element subChild = this.findChildAt(path);
        if (subChild == null) {
            return null;
        }
        return subChild.getAttribute(name);
    }

    public @NonNull Map<String, String> getAttributes() {
        return this.attributes != ATTRIBUTES_EMPTY ? Collections.unmodifiableMap(this.attributes) : ATTRIBUTES_EMPTY;
    }

    public @NonNull Element setAttributes(@NonNull Map<String, String> attributes) {
        this.attributes = new HashMap<String, String>(attributes.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public @Nullable String getCData() {
        return this.cdataToString();
    }

    public @Nullable String getCDataAt(@NonNull Path path) {
        Element subChild = this.findChildAt(path);
        if (subChild == null) {
            return null;
        }
        return subChild.getCData();
    }

    public @NonNull Element setCData(@NonNull String cdata) {
        this.nodes = new ArrayList<XMLNodeIfc>();
        this.addNode(new CData(cdata));
        return this;
    }

    public @NonNull List<Element> getChildren() {
        if (this.nodes != NODES_EMPTY) {
            ArrayList<Element> result = new ArrayList<Element>();
            this.forEachChild(result::add);
            return result;
        }
        return Collections.emptyList();
    }

    public @NonNull Element setChildren(@NonNull List<XMLNodeIfc> nodes) {
        this.nodes = new ArrayList<XMLNodeIfc>(nodes.size());
        for (XMLNodeIfc node : nodes) {
            Objects.requireNonNull(node, "Child cannot be null!");
            this.nodes.add((XMLNodeIfc)node.clone());
        }
        return this;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @Nullable String getXMLNS() {
        if (this.xmlns == null) {
            this.xmlns = this.getAttribute(ATTR_XMLNS_KEY);
        }
        return this.xmlns;
    }

    public @NonNull Element setXMLNS(@Nullable String ns) {
        if (ns == null) {
            this.removeAttribute(ATTR_XMLNS_KEY);
        } else {
            this.setAttribute(ATTR_XMLNS_KEY, ns);
        }
        return this;
    }

    public int hashCode() {
        return Objects.hashCode(this.name) + Objects.hashCode(this.xmlns) + Objects.hashCode(this.attributes);
    }

    public <R> @Nullable R map(@NonNull Function<Element, ? extends R> mapper) {
        return mapper.apply(this);
    }

    public @NonNull Element modify(@NonNull Consumer<Element> modifier) {
        modifier.accept(this);
        return this;
    }

    public <R> R mapChild(@NonNull Predicate<Element> predicate, @NonNull Function<Element, R> mapper) {
        Element child = this.findChild(predicate);
        if (child == null) {
            return null;
        }
        return mapper.apply(child);
    }

    public <R> @NonNull List<R> mapChildren(@NonNull Function<Element, ? extends R> mapper) {
        return this.mapChildren(null, mapper, null);
    }

    public <R> @NonNull List<R> mapChildren(@NonNull Predicate<Element> predicate, @NonNull Function<Element, ? extends R> mapper) {
        return this.mapChildren(predicate, mapper, null);
    }

    @NotNull
    public <R> List<R> compactMapChildren(@NonNull Function<Element, ? extends R> mapper) {
        return this.mapChildren(null, mapper, Objects::nonNull);
    }

    @NotNull
    public <R> List<R> compactMapChildren(@Nullable Predicate<Element> predicate, @NonNull Function<Element, ? extends R> mapper) {
        return this.mapChildren(predicate, mapper, Objects::nonNull);
    }

    @NotNull
    private <R> List<R> mapChildren(@Nullable Predicate<Element> predicate, @NonNull Function<Element, ? extends R> mapper, @Nullable Predicate<R> elementPredicate) {
        return ElementMapperHelper.toList(consumer -> {
            Consumer<Element> mappingConsumer = ElementMapperHelper.map(mapper, elementPredicate == null ? consumer : ElementMapperHelper.filter(elementPredicate, consumer));
            this.forEachChild(predicate == null ? mappingConsumer : ElementMapperHelper.filter(predicate, mappingConsumer));
        });
    }

    public void forEachChild(Consumer<Element> consumer) {
        for (XMLNodeIfc node : this.nodes) {
            if (!(node instanceof Element)) continue;
            consumer.accept((Element)node);
        }
    }

    public void forEachChild(@NonNull Predicate<Element> predicate, Consumer<Element> consumer) {
        this.forEachChild(child -> {
            if (predicate.test((Element)child)) {
                consumer.accept((Element)child);
            }
        });
    }

    public boolean matches(@NonNull Predicate<Element> predicate) {
        return predicate.test(this);
    }

    public void removeAttribute(@NonNull String name) {
        if (this.attributes != ATTRIBUTES_EMPTY) {
            if (ATTR_XMLNS_KEY.equals(name)) {
                this.xmlns = null;
            }
            this.attributes.remove(name);
        }
    }

    public boolean removeChild(@NonNull Element child) {
        boolean res = false;
        if (this.nodes != NODES_EMPTY) {
            res = this.nodes.remove(child);
        }
        return res;
    }

    public boolean removeChild(@NonNull String name, @NonNull String xmlns) {
        Element child = this.findChild(name, xmlns);
        if (child == null) {
            return false;
        }
        return this.removeChild(child);
    }

    public boolean removeChild(@NonNull Predicate<Element> predicate) {
        Element child = this.findChild(predicate);
        if (child != null) {
            this.nodes.remove(child);
        }
        return child != null;
    }

    public boolean hasAttribute(@NonNull String name) {
        return this.getAttribute(name) != null;
    }

    public boolean hasAttribute(@NonNull String name, @NonNull String value) {
        return Objects.equals(value, this.getAttribute(name));
    }

    public @NonNull Element setAttribute(@NonNull String name, @NonNull String value) {
        Objects.requireNonNull(name, "Attribute name cannot be null.");
        Objects.requireNonNull(value, "Attribute value cannot be null.");
        if (this.attributes == ATTRIBUTES_EMPTY) {
            this.attributes = new HashMap<String, String>(5);
        }
        String n = attributesDeduplicationFn.apply(name, name);
        String v = value;
        if (ATTR_XMLNS_KEY.equals(n)) {
            this.xmlns = v;
        }
        this.attributes.put(n, v);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.toString(result);
        return result.toString();
    }

    public void toString(StringBuilder result) {
        result.append("<").append(this.name);
        if (!this.attributes.isEmpty()) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append(this.attributes.get(key)).append("\"");
            }
        }
        if (!this.nodes.isEmpty()) {
            result.append(">");
            this.nodesToString(result);
            result.append("</").append(this.name).append(">");
        } else {
            result.append("/>");
        }
    }

    @Override
    public String toStringPretty() {
        StringBuilder result = new StringBuilder();
        result.append("<").append(this.name);
        if (!this.attributes.isEmpty()) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append(this.attributes.get(key)).append("\"");
            }
        }
        if (!this.nodes.isEmpty()) {
            result.append(">");
            result.append("\n");
            this.nodesToString(result);
            result.append("</").append(this.name).append(">");
            result.append("\n");
        } else {
            result.append("/>");
            result.append("\n");
        }
        return result.toString();
    }

    public String toStringNoChildren() {
        String cdata;
        StringBuilder result = new StringBuilder();
        result.append("<").append(this.name);
        if (!this.attributes.isEmpty()) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append(this.attributes.get(key)).append("\"");
            }
        }
        if ((cdata = this.cdataToString()) != null) {
            result.append(">");
            result.append(cdata);
            result.append("</").append(this.name).append(">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    @Override
    public String toStringSecure() {
        StringBuilder result = new StringBuilder();
        this.toStringSecure(result);
        return result.toString();
    }

    public void toStringSecure(StringBuilder result) {
        result.append("<").append(this.name);
        if (!this.attributes.isEmpty()) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append(this.attributes.get(key)).append("\"");
            }
        }
        if (!this.nodes.isEmpty()) {
            result.append(">");
            this.nodesToStringSecure(result);
            result.append("</").append(this.name).append(">");
        } else {
            result.append("/>");
        }
    }

    public String cdataToString() {
        StringBuilder result = new StringBuilder();
        for (XMLNodeIfc node : this.nodes) {
            if (!(node instanceof CData)) continue;
            result.append(node.toString());
        }
        return !result.isEmpty() ? result.toString() : null;
    }

    private static class ElementMapperHelper {
        private ElementMapperHelper() {
        }

        protected static <X> List<X> toList(Consumer<Consumer<X>> consumer) {
            ArrayList result = new ArrayList();
            consumer.accept(result::add);
            return result;
        }

        protected static <X, Y> Consumer<Y> map(@NonNull Function<Y, ? extends X> mapper, @NonNull Consumer<X> consumer) {
            return el -> consumer.accept(mapper.apply(el));
        }

        protected static <X> Consumer<X> filter(@NonNull Predicate<X> predicate, @NonNull Consumer<X> consumer) {
            return it -> {
                if (predicate.test(it)) {
                    consumer.accept(it);
                }
            };
        }
    }
}

