/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import tigase.xml.DefaultElementFactory;
import tigase.xml.Element;
import tigase.xml.ElementFactory;
import tigase.xml.ElementFilters;
import tigase.xml.SimpleHandler;

public class DomBuilderHandler
implements SimpleHandler {
    private static ElementFactory defaultFactory = new DefaultElementFactory();
    private static System.Logger log = System.getLogger(DomBuilderHandler.class.getName());
    private Deque<Element> all_roots = new ArrayDeque<Element>();
    private ElementFactory customFactory = null;
    private Deque<Element> el_stack = new ArrayDeque<Element>();
    private Map<String, String> namespaces = new TreeMap<String, String>();
    private Object parserState = null;
    private String top_xmlns = null;

    public DomBuilderHandler(ElementFactory factory) {
        this.customFactory = factory;
    }

    public DomBuilderHandler() {
        this.customFactory = defaultFactory;
    }

    public Queue<Element> getParsedElements() {
        return this.all_roots;
    }

    @Override
    public void error(String errorMessage) {
        log.log(System.Logger.Level.WARNING, "XML content parse error: {0}\n\n===", errorMessage);
    }

    @Override
    public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
        log.log(System.Logger.Level.TRACE, () -> "Start element name: " + String.valueOf(name) + "; Element attributes names: " + Arrays.toString(attr_names) + "; Element attributes values: " + Arrays.toString(attr_values));
        if (attr_names != null) {
            for (int i = 0; i < attr_names.length && attr_names[i] != null; ++i) {
                if (!attr_names[i].toString().startsWith("xmlns:")) continue;
                this.namespaces.put(attr_names[i].substring("xmlns:".length(), attr_names[i].length()), attr_values[i].toString());
            }
        }
        String tmp_name = name.toString();
        String new_xmlns = null;
        String prefix = null;
        String tmp_name_prefix = null;
        int idx = tmp_name.indexOf(58);
        if (idx > 0) {
            tmp_name_prefix = tmp_name.substring(0, idx);
        }
        if (tmp_name_prefix != null) {
            for (String pref : this.namespaces.keySet()) {
                if (!tmp_name_prefix.equals(pref)) continue;
                new_xmlns = this.namespaces.get(pref);
                tmp_name = tmp_name.substring(pref.length() + 1, tmp_name.length());
                prefix = pref;
            }
        }
        Element elem = this.newElement(tmp_name, null, attr_names, attr_values);
        String ns = elem.getXMLNS();
        if (new_xmlns != null) {
            elem.setXMLNS(new_xmlns);
            elem.removeAttribute("xmlns:" + prefix);
        }
        this.el_stack.push(elem);
    }

    @Override
    public void elementCData(StringBuilder cdata) {
        log.log(System.Logger.Level.TRACE, () -> "Element cdata: " + String.valueOf(cdata));
        try {
            this.el_stack.peek().addCData(cdata.toString());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    @Override
    public boolean endElement(StringBuilder name) {
        Element elem;
        log.log(System.Logger.Level.TRACE, () -> "End element name: " + String.valueOf(name));
        String tmp_name = name.toString();
        String tmp_name_prefix = null;
        int idx = tmp_name.indexOf(58);
        if (idx > 0) {
            tmp_name_prefix = tmp_name.substring(0, idx);
        }
        if (tmp_name_prefix != null) {
            for (String pref : this.namespaces.keySet()) {
                if (!tmp_name_prefix.equals(pref)) continue;
                tmp_name = tmp_name.substring(pref.length() + 1, tmp_name.length());
            }
        }
        if (this.el_stack.isEmpty()) {
            this.el_stack.push(this.newElement(tmp_name, null, null, null));
        }
        if (!(elem = this.el_stack.pop()).matches(ElementFilters.name(tmp_name))) {
            return false;
        }
        if (this.el_stack.isEmpty()) {
            this.all_roots.offer(elem);
            log.log(System.Logger.Level.TRACE, () -> "Adding new request: " + elem.toString());
        } else {
            this.el_stack.peek().addChild(elem);
        }
        return true;
    }

    @Override
    public void otherXML(StringBuilder other) {
        log.log(System.Logger.Level.TRACE, () -> "Other XML content: " + String.valueOf(other));
    }

    @Override
    public void saveParserState(Object state) {
        this.parserState = state;
    }

    @Override
    public Object restoreParserState() {
        return this.parserState;
    }

    private Element newElement(String name, String cdata, StringBuilder[] attnames, StringBuilder[] attvals) {
        return this.customFactory.elementInstance(name, cdata, attnames, attvals);
    }
}

