/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import org.junit.Assert;
import org.junit.Test;
import tigase.xml.Element;
import tigase.xml.ElementMatcher;
import tigase.xml.Path;

public class ElementMatcherTest {
    private static final String DATA = "parent[@xmlns='xmpp:1']";

    @Test
    public void testParseAndSerialize() throws Path.PathFormatException {
        ElementMatcher matcher = ElementMatcher.parse((String)DATA);
        Assert.assertEquals((Object)DATA, (Object)matcher.toString());
    }

    @Test
    public void testBuilderAndSerialize() throws Path.PathFormatException {
        ElementMatcher matcher = new ElementMatcher().setName("parent").setXMLNS("xmpp:1");
        Assert.assertEquals((Object)DATA, (Object)matcher.toString());
    }

    @Test
    public void testMatcher() throws Path.PathFormatException {
        ElementMatcher matcher = ElementMatcher.parse((String)DATA);
        Element el = new Element("parent").setXMLNS("xmpp:1");
        Assert.assertTrue((boolean)matcher.test(el));
        el = new Element("parent");
        Assert.assertFalse((boolean)matcher.test(el));
        el = new Element("par").setXMLNS("xmpp:1");
        Assert.assertFalse((boolean)matcher.test(el));
    }
}

