/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import tigase.xml.Element;

@Ignore
public class ElementAttributesPerformanceTest {
    @Test
    public void launchBenchmark() throws RunnerException {
        Options opt = new OptionsBuilder().include(this.getClass().getName() + ".*").timeUnit(TimeUnit.MICROSECONDS).warmupTime(TimeValue.seconds((long)1L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)1L)).measurementIterations(5).threads(2).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        new Runner(opt).run();
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void benchmarkAttributeGet(BenchmarkState state, Blackhole blackhole) {
        blackhole.consume((Object)state.element.getAttribute(state.attributeName));
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void benchmarkAttributePut(BenchmarkState state, Blackhole blackhole) {
        state.element.setAttribute(state.attributeName, state.attributeName);
        blackhole.consume(true);
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void benchmarkAttributeRemove(BenchmarkState state, Blackhole blackhole) {
        state.element.removeAttribute(state.attributeName);
        blackhole.consume(true);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkState {
        Element element;
        String attributeName;
        @Param(value={"Dynamic", "Static"})
        String attributeType;

        @Setup(value=Level.Trial)
        public void initializeElement() {
            switch (this.attributeType) {
                case "Dynamic": {
                    this.attributeName = "test-" + new Random().nextInt();
                    break;
                }
                case "Static": {
                    this.attributeName = "id";
                }
            }
            this.element = new Element("root").setAttribute(new String(this.attributeName), "true");
        }
    }
}

