/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tigase.xml.Element;
import tigase.xml.Path;

public class ElementMatcher
implements Predicate<Element> {
    private String name;
    private String xmlns;
    private Attribute[] attributes;

    protected static @NonNull ElementMatcher parse(@NonNull Path.State state) throws Path.PathFormatException {
        int nameEndIdx;
        String name;
        int slashIdx = state.text.indexOf(47);
        int squareIdx = state.text.indexOf(91);
        if (slashIdx == -1) {
            slashIdx = Integer.MAX_VALUE;
        }
        if ((name = state.text.substring(0, nameEndIdx = Math.min(slashIdx, squareIdx))).isEmpty()) {
            throw new Path.PathFormatException("Element name cannot be empty!");
        }
        if ("*".equals(name)) {
            name = null;
        }
        state.text = state.text.substring(nameEndIdx);
        if (slashIdx < squareIdx) {
            state.text = state.text.substring(slashIdx);
            return new ElementMatcher(name, null, Collections.emptyList());
        }
        String xmlns = null;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        while (state.text.startsWith("[")) {
            Attribute attr = Attribute.parse(state);
            if ("xmlns".equals(attr.name)) {
                xmlns = attr.value;
                continue;
            }
            attributes.add(attr);
        }
        return new ElementMatcher(name, xmlns, attributes);
    }

    public static @NonNull ElementMatcher parse(@NonNull String text) throws Path.PathFormatException {
        Path.State state = new Path.State(text);
        return ElementMatcher.parse(state);
    }

    public ElementMatcher() {
        this.name = null;
        this.xmlns = null;
        this.attributes = new Attribute[0];
    }

    public ElementMatcher(@Nullable String name, @Nullable String xmlns, @Nullable List<Attribute> attributes) {
        this(name, xmlns, attributes != null ? (Attribute[])attributes.toArray(Attribute[]::new) : new Attribute[]{});
    }

    public @NonNull ElementMatcher setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public @NonNull ElementMatcher setXMLNS(@Nullable String xmlns) {
        this.xmlns = xmlns;
        return this;
    }

    public @NonNull ElementMatcher addAttribute(@NonNull String name, @Nullable String value) {
        Objects.requireNonNull(name, "Attribute name cannot be null!");
        this.attributes = Arrays.copyOf(this.attributes, this.attributes.length + 1);
        this.attributes[this.attributes.length - 1] = new Attribute(name, value);
        return this;
    }

    private ElementMatcher(@Nullable String name, @Nullable String xmlns, @NonNull Attribute[] attributes) {
        this.name = name;
        this.xmlns = xmlns;
        this.attributes = attributes;
    }

    @Override
    public boolean test(@NonNull Element element) {
        if (this.name != null && !this.name.equals(element.getName())) {
            return false;
        }
        if (this.xmlns != null && !this.xmlns.equals(element.getXMLNS())) {
            return false;
        }
        for (Attribute attr : this.attributes) {
            String value = element.getAttribute(attr.name);
            if (!(attr.value != null ? !Objects.equals(attr.value, value) : value == null)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ElementMatcher) {
            ElementMatcher o = (ElementMatcher)obj;
            if (Objects.equals(this.name, o.name) && Objects.equals(this.xmlns, o.xmlns) && this.attributes.length == o.attributes.length) {
                for (Attribute attr : this.attributes) {
                    boolean found = false;
                    for (Attribute attr1 : this.attributes) {
                        if (!Objects.equals(attr, attr1)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.xmlns);
        result = 31 * result + Arrays.hashCode(this.attributes);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public void toStringBuilder(StringBuilder sb) {
        if (this.name == null) {
            sb.append("*");
        } else {
            sb.append(this.name);
        }
        if (this.xmlns != null) {
            sb.append("[@xmlns='").append(this.xmlns).append("']");
        }
        for (Attribute attr : this.attributes) {
            sb.append("[@" + attr.name);
            if (attr.value != null) {
                sb.append("='").append(attr.value).append("'");
            }
            sb.append("]");
        }
    }

    public record Attribute(@NonNull String name, @Nullable String value) {
        protected static @NonNull Attribute parse(@NonNull Path.State state) throws Path.PathFormatException {
            int squareIdx;
            if (!state.text.startsWith("[@") || state.text.length() < 2) {
                throw new Path.PathFormatException("Invalid attribute format");
            }
            state.text = state.text.substring(2);
            int quoteIdx = state.text.indexOf(39);
            if (quoteIdx < (squareIdx = state.text.indexOf(93))) {
                if (quoteIdx > 1 && state.text.charAt(quoteIdx - 1) == '=') {
                    String name = state.text.substring(0, quoteIdx - 1);
                    state.text = state.text.substring(quoteIdx + 1);
                    int endIdx = state.text.indexOf(39);
                    if (endIdx < 0) {
                        throw new Path.PathFormatException("Invalid attribute format - missing end of value");
                    }
                    String value = state.text.substring(0, endIdx);
                    state.text = state.text.substring(endIdx + 2);
                    return new Attribute(name, value);
                }
                throw new Path.PathFormatException("Invalid attribute format - missing value");
            }
            if (squareIdx <= 1) {
                throw new Path.PathFormatException("Invalid attribute format - empty attribute condition");
            }
            state.text = state.text.substring(squareIdx + 1);
            return new Attribute(state.text.substring(0, squareIdx), null);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            return this.name.equals(attribute.name) && Objects.equals(this.value, attribute.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }
    }
}

