/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import tigase.xml.Element;

public class ElementFilters {
    @NotNull
    public static Predicate<Element> xmlns(@NotNull String xmlns) {
        return el -> xmlns.equals(el.getXMLNS());
    }

    @NotNull
    public static Predicate<Element> name(@NotNull String name) {
        return el -> name.equals(el.getName());
    }

    @NotNull
    public static Predicate<Element> attribute(@NotNull String name, @NotNull String value) {
        return el -> name.equals(el.getAttribute(value));
    }

    @NotNull
    public static Predicate<Element> nameAndAttribute(@NotNull String name, @NotNull String attributeName, @NotNull String attributeValue) {
        return ElementFilters.name(name).and(ElementFilters.attribute(attributeName, attributeValue));
    }

    @NotNull
    public static Predicate<Element> nameAndXMLNS(@NotNull String name, @NotNull String xmlns) {
        return ElementFilters.name(name).and(ElementFilters.xmlns(xmlns));
    }
}

