/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Ignore;
import org.junit.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

@Ignore
public class StringPerformanceTest {
    private static final Map<String, String> DEDUP_ELEM_NAME = List.of("message", "iq", "presence", "query", "pubsub", "body").stream().collect(Collectors.toMap(Function.identity(), Function.identity()));

    @Test
    public void launchBenchmark() throws RunnerException {
        Options opt = new OptionsBuilder().include(this.getClass().getName() + ".*").timeUnit(TimeUnit.MICROSECONDS).warmupTime(TimeValue.seconds((long)1L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)1L)).measurementIterations(5).threads(2).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        new Runner(opt).run();
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void stringIntern(BenchmarkState state, Blackhole blackhole) {
        blackhole.consume((Object)state.name.intern());
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void stringDeduplication(BenchmarkState state, Blackhole blackhole) {
        blackhole.consume((Object)DEDUP_ELEM_NAME.getOrDefault(state.name, state.name));
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void stringNope(BenchmarkState state, Blackhole blackhole) {
        blackhole.consume((Object)state.name);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkState {
        String name;
        boolean dedup = false;

        @Setup(value=Level.Trial)
        public void initializeElement() {
            this.dedup = true;
            List namesToUse = Stream.concat(DEDUP_ELEM_NAME.keySet().stream(), IntStream.range(0, 20).mapToObj(i -> "child-" + i)).map(String::new).collect(Collectors.toList());
            Collections.shuffle(namesToUse);
            int selected = new Random().nextInt(namesToUse.size());
            this.name = (String)namesToUse.get(selected);
        }
    }
}

