/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;

public class SimpleParserTest {
    private SimpleParser parser;

    @Before
    public void setUp() {
        this.parser = new SimpleParser();
    }

    @After
    public void tearDown() {
        this.parser = null;
    }

    @Test
    public void testNPE() {
        SimpleHandler handler = new SimpleHandler(this){
            Object state;

            public void error(String errorMessage) {
            }

            public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
            }

            public void elementCData(StringBuilder cdata) {
            }

            public boolean endElement(StringBuilder name) {
                return true;
            }

            public void otherXML(StringBuilder other) {
            }

            public void saveParserState(Object state) {
                this.state = state;
            }

            public Object restoreParserState() {
                return this.state;
            }
        };
        String input = "<root test1 \"test2\"/>";
        char[] data = input.toCharArray();
        this.parser.parse(handler, data, 0, data.length);
    }

    @Test
    public void testParse() {
        String input = "<message test=\"test\"><body>body</body><html><body><p><em>Wow</em>*, I&apos;m* <span>green</span>with <strong>envy</strong>!</p></body></html></message>";
        DomBuilderHandler domHandler = new DomBuilderHandler();
        Queue parsedElements = null;
        char[] data = input.toCharArray();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        parsedElements = domHandler.getParsedElements();
        if (parsedElements != null && parsedElements.size() > 0) {
            Element el = (Element)parsedElements.poll();
            boolean equals = input.equals(el.toString());
            Assert.assertTrue((String)"Input and output are different!", (boolean)equals);
        }
    }

    @Test
    public void testChars() {
        SimpleHandler handler = new SimpleHandler(this){
            Object state;

            public void error(String errorMessage) {
            }

            public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
            }

            public void elementCData(StringBuilder cdata) {
            }

            public boolean endElement(StringBuilder name) {
                return true;
            }

            public void otherXML(StringBuilder other) {
            }

            public void saveParserState(Object state) {
                this.state = state;
            }

            public Object restoreParserState() {
                return this.state;
            }
        };
        char[] data = "<test/>".toCharArray();
        this.parser.parse(handler, data, 0, data.length);
        handler.saveParserState(null);
        String dataStr = "<test>" + Character.toChars(127479) + "</test>";
        data = dataStr.toCharArray();
        this.parser.parse(handler, data, 0, data.length);
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        data = "<test>\u0000</test".toCharArray();
        this.parser.parse(handler, data, 0, data.length);
        Assert.assertEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
    }

    @Test
    public void testEntities() throws InstantiationException, IllegalAccessException {
        AtomicBoolean error = new AtomicBoolean(false);
        DomBuilderHandlerImpl handler = new DomBuilderHandlerImpl(this, error);
        char[] data = "<message from=\"test@example.com\"><body>\u00a9 \u00a7      \u2209 \u21d2 </body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertFalse((boolean)error.get());
        Assert.assertEquals((Object)"\u00a9 \u00a7      \u2209 \u21d2 ", (Object)((Element)handler.getParsedElements().poll()).findChild("body").getCData());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\"><body>123 - &#123;</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertEquals((Object)"123 - &#123;", (Object)((Element)handler.getParsedElements().poll()).findChild("body").getCData());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\"><body>123 - &a123;</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertEquals((Object)"123 - &a123;", (Object)((Element)handler.getParsedElements().poll()).findChild("body").getCData());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\"><body>123 - &123;</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\"><body>123 - &#123</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\"><body>123 - &a123</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\" id=\"&a123;\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertEquals((Object)"&a123;", (Object)((Element)handler.getParsedElements().poll()).getAttribute("id"));
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\" id=\"&#123;\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertEquals((Object)"&#123;", (Object)((Element)handler.getParsedElements().poll()).getAttribute("id"));
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\" id=\"&123;\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\" id=\"&a123\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<mes&sage from=\"test@example.com\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<mes&amp;sage from=\"test@example.com\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\"><<body>Test</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message from=\"test@example.com\"><body>Test</body1></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"test@zeus\" type=\"chat\" id=\"t&amp;t<\"><body>Test &amp; done</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<db:result to=\"malkowscy.net\" from=\"brzezinski.mobi\">CAESBxCXyf6RqCoaEGFkhIYrlYto/kK5GTcsaTw=</db:result><db:verify to=\"malkowscy.net\" from=\"brzezinski.mobi\" id=\"1B6476BAD2C0BF34\">4ab1c1d99f40263822ae7d4851854eb158e46325009e928a66b1148ee4fed331</db:verify><db:result to=\"malkowscy.net\" from=\"gmail.com\">CAESBxCXyf6RqCoaEGPHnXDLTIeKBNx9ZJ1SmzM=</db:result>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<body xmlns:xmpp=\"urn:xmpp:xbosh\" ack=\"6621206\" from=\"test\" xmlns=\"http://jabber.org/protocol/httpbind\" secure=\"true\" xmpp:version=\"1.0\" xmlns:stream=\"http://etherx.jabber.org/streams\" host=\"mbp-andrzej.local\"><stream:features xmlns=\"jabber:client\"><auth xmlns=\"http://jabber.org/features/iq-auth\"/><mechanisms xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\"><mechanism>SCRAM-SHA-1</mechanism><mechanism>PLAIN</mechanism><mechanism>ANONYMOUS</mechanism></mechanisms><register xmlns=\"http://jabber.org/features/iq-register\"/><ver xmlns=\"urn:xmpp:features:rosterver\"/><starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/><compression xmlns=\"http://jabber.org/features/compress\"><method>zlib</method></compression></stream:features></body>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\"><body>\"<\\/>\"</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\"><body><*/></body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\"><body><=\\\"\"/></body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\"><body><\ud801\udc37/></body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\"><body><\ud800\udc00/></body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\"><body><\udb7f\udfff/></body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\"><body><\udbff\udfff/></body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\"><body><\ud810\udc37/></body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\"><body><\udc37/></body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\" *=\"test\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
        data = "<message to=\"bob@domain\" type=\"chat\" test-attr=\"xxx\"><body></body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((String)Optional.ofNullable((Element)handler.getParsedElements().peek()).toString(), (boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(this, error);
    }

    @Test
    public void testEntityAndAttributeNameCharValidation() {
        SimpleParser parser = new SimpleParser();
        for (char chr = '\u0000'; chr < '\uffff'; chr = (char)(chr + '\u0001')) {
            Assert.assertEquals((Object)this.checkIsCharValidNameStartChar(chr), (Object)parser.checkIsCharValidNameChar(chr, true));
            Assert.assertEquals((Object)this.checkIsCharValidNameChar(chr), (Object)parser.checkIsCharValidNameChar(chr, false));
        }
    }

    private boolean checkIsCharValidNameStartChar(char chr) {
        int high;
        if (chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr == ':' || chr == '_') {
            return true;
        }
        if (chr >= '\u00c0' && chr <= '\u02ff') {
            return chr != '\u00d7' && chr != '\u00f7';
        }
        if (chr >= '\u0370' && chr <= '\u1fff') {
            return chr != '\u037e';
        }
        if (chr >= '\u200c' && chr <= '\u200d') {
            return true;
        }
        if (chr >= '\u2070' && chr <= '\u218f') {
            return true;
        }
        if (chr >= '\u2c00' && chr <= '\u2fef') {
            return true;
        }
        if (chr >= '\u3001' && chr <= '\ud7ff') {
            return true;
        }
        if (chr >= '\uf900' && chr <= '\ufdcf') {
            return true;
        }
        if (chr >= '\ufdf0' && chr <= '\ufffd') {
            return true;
        }
        return Character.isHighSurrogate(chr) ? (high = chr - 55296) <= 895 : Character.isLowSurrogate(chr);
    }

    private boolean checkIsCharValidNameChar(char chr) {
        if (this.checkIsCharValidNameStartChar(chr)) {
            return true;
        }
        if (chr >= '0' && chr <= '9' || chr == '-' || chr == '.' || chr == '\u00b7') {
            return true;
        }
        if (chr >= '\u0300' && chr <= '\u036f') {
            return true;
        }
        return chr >= '\u203f' && chr <= '\u2040';
    }

    public void testPerformance() {
        SimpleParser parser = new SimpleParser();
        Character[] data = (Character[])IntStream.range(0, 256).filter(c -> c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 58 || c == 46 || c == 45 || c == 183).mapToObj(c -> Character.valueOf((char)c)).toArray(Character[]::new);
        StringBuilder sb = new StringBuilder();
        for (Character c2 : data) {
            sb.append(c2);
        }
        System.out.println("testing chars: " + String.valueOf(sb));
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10000000; ++i) {
            for (int j = 0; j < data.length; ++j) {
                parser.checkIsCharValidNameChar(data[j].charValue(), true);
                parser.checkIsCharValidNameChar(data[j].charValue(), false);
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("time: " + (end - start) + "ms");
    }

    private class DomBuilderHandlerImpl
    extends DomBuilderHandler {
        private AtomicBoolean error;

        public DomBuilderHandlerImpl(SimpleParserTest simpleParserTest, AtomicBoolean error) {
            this.error = error;
        }

        public void error(String errorMessage) {
            this.error.set(true);
        }

        public void saveParserState(Object state) {
            super.saveParserState(state);
            if (state == null) {
                this.error.set(false);
            }
        }
    }
}

