/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.xml.Element;
import tigase.xml.ElementFilters;
import tigase.xml.ElementMatcher;
import tigase.xml.Path;

public class ElementTest {
    private static final String xmlns = "xmlns:1";
    private static final Path path = Path.of((ElementMatcher[])new ElementMatcher[]{new ElementMatcher("parent", null, Collections.emptyList()), new ElementMatcher("child", null, Collections.emptyList())});
    private static final Path pathComplex = Path.of((ElementMatcher[])new ElementMatcher[]{new ElementMatcher("parent", null, Collections.emptyList()), new ElementMatcher("child", "xmlns:1", List.of(new ElementMatcher.Attribute("child_att_name", "child_att_value")))});
    private String c_att_name = null;
    private String c_att_value = null;
    private Element child = null;
    private String p_att_name = null;
    private String p_att_value = null;
    private Element parent = null;
    private String value = null;

    @Before
    public void setUp() throws Exception {
        this.value = "correct-value";
        this.parent = new Element("parent");
        this.child = new Element("child").setXMLNS(xmlns);
        this.child.setCData(this.value);
        this.child.setCData(this.value);
        this.child.setCData(this.value);
        this.parent.addChild(this.child);
        this.p_att_name = "parent_att_name";
        this.p_att_value = "parent_att_value";
        this.parent.setAttribute(this.p_att_name, this.p_att_value);
        this.c_att_name = "child_att_name";
        this.c_att_value = "child_att_value";
        this.child.setAttribute(this.c_att_name, this.c_att_value);
    }

    @After
    public void tearDown() throws Exception {
        this.parent = null;
        this.child = null;
        this.value = null;
        this.p_att_name = null;
        this.p_att_value = null;
        this.c_att_name = null;
        this.c_att_value = null;
    }

    @Test
    public void testAddAttribute() {
        String attName = "key";
        String attValue = "value";
        this.parent.setAttribute(attName, attValue);
        Assert.assertEquals((Object)attValue, (Object)this.parent.getAttribute(attName));
    }

    @Test
    public void testAddAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        this.parent.removeAttribute(this.p_att_name);
        attrs.put("key1", "val1");
        attrs.put("key2", "val2");
        this.parent.setAttributes(attrs);
        Assert.assertEquals((long)attrs.size(), (long)this.parent.getAttributes().size());
        Assert.assertEquals(attrs, (Object)this.parent.getAttributes());
    }

    @Test
    public void testAddChild() {
        Element instance = new Element("elem1").setCData("cdata1");
        this.parent.addChild(instance);
        Assert.assertEquals((Object)instance, (Object)this.parent.findChild("elem1"));
    }

    @Test
    public void testClone() {
        Element result = this.parent.clone();
        Assert.assertEquals((Object)this.parent, (Object)result);
    }

    @Test
    public void testFindChildAt_Simple() {
        Element result = this.parent.findChildAt(path);
        Assert.assertEquals((Object)this.child, (Object)result);
    }

    @Test
    public void testFindChildAt_Complex() {
        Element result = this.parent.findChildAt(pathComplex);
        Assert.assertEquals((Object)this.child, (Object)result);
    }

    @Test
    public void testFindChildrenAt_Simple() {
        List result = this.parent.findChildrenAt(path);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.child, result.get(0));
    }

    @Test
    public void testFindChildrenAt_Complex() {
        List result = this.parent.findChildrenAt(pathComplex);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.child, result.get(0));
    }

    @Test
    public void testGetAttribute() {
        Assert.assertEquals((Object)this.p_att_value, (Object)this.parent.getAttribute(this.p_att_name));
    }

    @Test
    public void testGetAttributeAt() {
        Assert.assertEquals((Object)this.c_att_value, (Object)this.parent.getAttributeAt(path, this.c_att_name));
    }

    @Test
    public void testGetCDataAt() {
        Assert.assertEquals((Object)this.value, (Object)this.parent.getCDataAt(path));
    }

    @Test
    public void testGetCData() {
        Assert.assertEquals((Object)this.value, (Object)this.child.getCData());
    }

    @Test
    public void testFindChild() {
        Assert.assertEquals((Object)this.child, (Object)this.parent.findChild("child"));
        Assert.assertEquals((Object)this.child, (Object)this.parent.findChild(new String("child")));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"parent", (Object)this.parent.getName());
    }

    @Test
    public void testGetXMLNS() {
        Assert.assertEquals((Object)xmlns, (Object)this.child.getXMLNS());
    }

    @Test
    public void testRemoveAttribute() {
        this.parent.removeAttribute(this.p_att_name);
        Assert.assertNull((Object)this.parent.getAttribute(this.p_att_name));
    }

    @Test
    public void testRemoveChild() {
        this.parent.removeChild(this.child);
        Assert.assertNull((Object)this.parent.findChild("child"));
    }

    @Test
    public void testSetAttribute() {
        this.testAddAttribute();
    }

    @Test
    public void testSetCData() {
        this.testGetCData();
    }

    @Test
    public void testFindChildVariants() {
        Element element = new Element("root");
        for (int childIdx = 0; childIdx < 10; ++childIdx) {
            element.addChild(new Element("child-" + childIdx).addChild(new Element("subchild-1")));
        }
        Assert.assertEquals((Object)"child-1", (Object)element.findChild(el -> "child-1".equals(el.getName())).getName());
        Assert.assertEquals((Object)"child-1", (Object)element.findChild("child-1").getName());
        Assert.assertEquals((Object)"child-1", (Object)element.findChild(ElementFilters.name((String)"child-1")).getName());
    }
}

