/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import tigase.xml.Element;

@Ignore
public class ElementPerformanceTest {
    public static final String[] ATTRIBUTE_NAMES = new String[]{"id", "name", "from", "to", "xmlns"};
    private static final Map<String, String> ATTRIBUTES_MAP = Map.of("id", "id", "name", "name", "from", "from", "to", "to", "xmlns", "xmlns");

    @Test
    public void launchBenchmark() throws RunnerException {
        Options opt = new OptionsBuilder().include(this.getClass().getName() + ".*").timeUnit(TimeUnit.MICROSECONDS).warmupTime(TimeValue.seconds((long)1L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)1L)).measurementIterations(5).threads(2).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        new Runner(opt).run();
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void benchmarkElementWithAttributesCreationBuilder(Blackhole blackhole) {
        Element test = new Element("test");
        for (String name : ATTRIBUTE_NAMES) {
            test.setAttribute(name, name);
        }
        blackhole.consume((Object)test);
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void benchmarkElementWithAttributesCreationDynamicMap(Blackhole blackhole) {
        blackhole.consume((Object)new Element("test").setAttributes(Map.of("id", "id", "name", "name", "from", "from", "to", "to", "xmlns", "xmlns")));
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void benchmarkElementWithAttributesCreationDynamicMapOfEntries(Blackhole blackhole) {
        blackhole.consume((Object)new Element("test").setAttributes(Map.ofEntries(Map.entry("id", "id"), Map.entry("name", "name"), Map.entry("from", "from"), Map.entry("to", "to"), Map.entry("xmlns", "xmlns"))));
    }

    @Benchmark
    @Measurement(iterations=1000)
    @BenchmarkMode(value={Mode.Throughput})
    public void benchmarkElementWithAttributesCreationStaticMap(Blackhole blackhole) {
        blackhole.consume((Object)new Element("test").setAttributes(ATTRIBUTES_MAP));
    }

    @State(value=Scope.Thread)
    public static class BenchmarkState {
        Element element;
        @Param(value={"1", "5", "10"})
        int maxChild;
        String name = "message";

        @Setup(value=Level.Trial)
        public void initializeElement() {
            this.element = new Element("root");
            for (int childIdx = 0; childIdx < this.maxChild - 1; ++childIdx) {
                this.element.addChild(new Element("child-" + childIdx + "1").addChild(new Element("subchild-1")));
            }
            this.name = new String(this.getNameToFind());
            this.element.addChild(new Element(this.name));
        }

        public String getNameToFind() {
            return "message";
        }
    }
}

